/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ListTablesRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private String pageToken;
    private Integer limit;

    public ListTablesRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public ListTablesRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public ListTablesRequest pageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    @Schema(name="page_token", description="An opaque token that allows pagination for list operations (e.g. ListNamespaces).  For an initial request of a list operation,  if the implementation cannot return all items in one response, or if there are more items than the page limit specified in the request, the implementation must return a page token in the response, indicating there are more results available.  After the initial request,  the value of the page token from each response must be used as the page token value for the next request.  Caller must interpret either `null`,  missing value or empty string value of the page token from the implementation's response as the end of the listing results. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="page_token")
    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public ListTablesRequest limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Schema(name="limit", description="An inclusive upper bound of the  number of results that a caller will receive. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="limit")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTablesRequest listTablesRequest = (ListTablesRequest)o;
        return Objects.equals(this.id, listTablesRequest.id) && Objects.equals(this.pageToken, listTablesRequest.pageToken) && Objects.equals(this.limit, listTablesRequest.limit);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.pageToken, this.limit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTablesRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    pageToken: ").append(this.toIndentedString(this.pageToken)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

