/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class ListTablesResponse {
    @Valid
    private Set<String> tables = new LinkedHashSet<String>();
    private String pageToken;

    public ListTablesResponse() {
    }

    public ListTablesResponse(Set<String> tables) {
        this.tables = tables;
    }

    public ListTablesResponse tables(Set<String> tables) {
        this.tables = tables;
        return this;
    }

    public ListTablesResponse addTablesItem(String tablesItem) {
        if (this.tables == null) {
            this.tables = new LinkedHashSet<String>();
        }
        this.tables.add(tablesItem);
        return this;
    }

    @NotNull
    @Schema(name="tables", description="The list of names of the tables relative to the parent namespace `id` in the request. ", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="tables")
    public Set<String> getTables() {
        return this.tables;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setTables(Set<String> tables) {
        this.tables = tables;
    }

    public ListTablesResponse pageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    @Schema(name="page_token", description="An opaque token that allows pagination for list operations (e.g. ListNamespaces).  For an initial request of a list operation,  if the implementation cannot return all items in one response, or if there are more items than the page limit specified in the request, the implementation must return a page token in the response, indicating there are more results available.  After the initial request,  the value of the page token from each response must be used as the page token value for the next request.  Caller must interpret either `null`,  missing value or empty string value of the page token from the implementation's response as the end of the listing results. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="page_token")
    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTablesResponse listTablesResponse = (ListTablesResponse)o;
        return Objects.equals(this.tables, listTablesResponse.tables) && Objects.equals(this.pageToken, listTablesResponse.pageToken);
    }

    public int hashCode() {
        return Objects.hash(this.tables, this.pageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTablesResponse {\n");
        sb.append("    tables: ").append(this.toIndentedString(this.tables)).append("\n");
        sb.append("    pageToken: ").append(this.toIndentedString(this.pageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

