/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.lancedb.lance.namespace.server.springboot.model.QueryTableRequestFullTextQuery;
import com.lancedb.lance.namespace.server.springboot.model.QueryTableRequestVector;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class QueryTableRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private Boolean bypassVectorIndex;
    @Valid
    private List<String> columns = new ArrayList<String>();
    private String distanceType;
    private Integer ef;
    private Boolean fastSearch;
    private String filter;
    private QueryTableRequestFullTextQuery fullTextQuery;
    private Integer k;
    private Float lowerBound;
    private Integer nprobes;
    private Integer offset;
    private Boolean prefilter;
    private Integer refineFactor;
    private Float upperBound;
    private QueryTableRequestVector vector;
    private String vectorColumn;
    private Long version;
    private Boolean withRowId;

    public QueryTableRequest() {
    }

    public QueryTableRequest(Integer k, QueryTableRequestVector vector) {
        this.k = k;
        this.vector = vector;
    }

    public QueryTableRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public QueryTableRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public QueryTableRequest bypassVectorIndex(Boolean bypassVectorIndex) {
        this.bypassVectorIndex = bypassVectorIndex;
        return this;
    }

    @Schema(name="bypass_vector_index", description="Whether to bypass vector index", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="bypass_vector_index")
    public Boolean getBypassVectorIndex() {
        return this.bypassVectorIndex;
    }

    public void setBypassVectorIndex(Boolean bypassVectorIndex) {
        this.bypassVectorIndex = bypassVectorIndex;
    }

    public QueryTableRequest columns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    public QueryTableRequest addColumnsItem(String columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @Schema(name="columns", description="Optional list of columns to return", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="columns")
    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public QueryTableRequest distanceType(String distanceType) {
        this.distanceType = distanceType;
        return this;
    }

    @Schema(name="distance_type", description="Distance metric to use", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="distance_type")
    public String getDistanceType() {
        return this.distanceType;
    }

    public void setDistanceType(String distanceType) {
        this.distanceType = distanceType;
    }

    public QueryTableRequest ef(Integer ef) {
        this.ef = ef;
        return this;
    }

    @Min(value=0L)
    @Schema(name="ef", description="Search effort parameter for HNSW index", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="ef")
    public @Min(value=0L) Integer getEf() {
        return this.ef;
    }

    public void setEf(Integer ef) {
        this.ef = ef;
    }

    public QueryTableRequest fastSearch(Boolean fastSearch) {
        this.fastSearch = fastSearch;
        return this;
    }

    @Schema(name="fast_search", description="Whether to use fast search", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="fast_search")
    public Boolean getFastSearch() {
        return this.fastSearch;
    }

    public void setFastSearch(Boolean fastSearch) {
        this.fastSearch = fastSearch;
    }

    public QueryTableRequest filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Schema(name="filter", description="Optional SQL filter expression", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="filter")
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public QueryTableRequest fullTextQuery(QueryTableRequestFullTextQuery fullTextQuery) {
        this.fullTextQuery = fullTextQuery;
        return this;
    }

    @Valid
    @Schema(name="full_text_query", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="full_text_query")
    public QueryTableRequestFullTextQuery getFullTextQuery() {
        return this.fullTextQuery;
    }

    public void setFullTextQuery(QueryTableRequestFullTextQuery fullTextQuery) {
        this.fullTextQuery = fullTextQuery;
    }

    public QueryTableRequest k(Integer k) {
        this.k = k;
        return this;
    }

    @NotNull
    @Min(value=0L)
    @Schema(name="k", description="Number of results to return", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="k")
    public @NotNull @Min(value=0L) Integer getK() {
        return this.k;
    }

    public void setK(Integer k) {
        this.k = k;
    }

    public QueryTableRequest lowerBound(Float lowerBound) {
        this.lowerBound = lowerBound;
        return this;
    }

    @Schema(name="lower_bound", description="Lower bound for search", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="lower_bound")
    public Float getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(Float lowerBound) {
        this.lowerBound = lowerBound;
    }

    public QueryTableRequest nprobes(Integer nprobes) {
        this.nprobes = nprobes;
        return this;
    }

    @Min(value=0L)
    @Schema(name="nprobes", description="Number of probes for IVF index", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="nprobes")
    public @Min(value=0L) Integer getNprobes() {
        return this.nprobes;
    }

    public void setNprobes(Integer nprobes) {
        this.nprobes = nprobes;
    }

    public QueryTableRequest offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Min(value=0L)
    @Schema(name="offset", description="Number of results to skip", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="offset")
    public @Min(value=0L) Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public QueryTableRequest prefilter(Boolean prefilter) {
        this.prefilter = prefilter;
        return this;
    }

    @Schema(name="prefilter", description="Whether to apply filtering before vector search", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="prefilter")
    public Boolean getPrefilter() {
        return this.prefilter;
    }

    public void setPrefilter(Boolean prefilter) {
        this.prefilter = prefilter;
    }

    public QueryTableRequest refineFactor(Integer refineFactor) {
        this.refineFactor = refineFactor;
        return this;
    }

    @Min(value=0L)
    @Schema(name="refine_factor", description="Refine factor for search", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="refine_factor")
    public @Min(value=0L) Integer getRefineFactor() {
        return this.refineFactor;
    }

    public void setRefineFactor(Integer refineFactor) {
        this.refineFactor = refineFactor;
    }

    public QueryTableRequest upperBound(Float upperBound) {
        this.upperBound = upperBound;
        return this;
    }

    @Schema(name="upper_bound", description="Upper bound for search", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="upper_bound")
    public Float getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(Float upperBound) {
        this.upperBound = upperBound;
    }

    public QueryTableRequest vector(QueryTableRequestVector vector) {
        this.vector = vector;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="vector", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="vector")
    public QueryTableRequestVector getVector() {
        return this.vector;
    }

    public void setVector(QueryTableRequestVector vector) {
        this.vector = vector;
    }

    public QueryTableRequest vectorColumn(String vectorColumn) {
        this.vectorColumn = vectorColumn;
        return this;
    }

    @Schema(name="vector_column", description="Name of the vector column to search", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="vector_column")
    public String getVectorColumn() {
        return this.vectorColumn;
    }

    public void setVectorColumn(String vectorColumn) {
        this.vectorColumn = vectorColumn;
    }

    public QueryTableRequest version(Long version) {
        this.version = version;
        return this;
    }

    @Min(value=0L)
    @Schema(name="version", description="Table version to query", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public @Min(value=0L) Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public QueryTableRequest withRowId(Boolean withRowId) {
        this.withRowId = withRowId;
        return this;
    }

    @Schema(name="with_row_id", description="If true, return the row id as a column called `_rowid`", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="with_row_id")
    public Boolean getWithRowId() {
        return this.withRowId;
    }

    public void setWithRowId(Boolean withRowId) {
        this.withRowId = withRowId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryTableRequest queryTableRequest = (QueryTableRequest)o;
        return Objects.equals(this.id, queryTableRequest.id) && Objects.equals(this.bypassVectorIndex, queryTableRequest.bypassVectorIndex) && Objects.equals(this.columns, queryTableRequest.columns) && Objects.equals(this.distanceType, queryTableRequest.distanceType) && Objects.equals(this.ef, queryTableRequest.ef) && Objects.equals(this.fastSearch, queryTableRequest.fastSearch) && Objects.equals(this.filter, queryTableRequest.filter) && Objects.equals(this.fullTextQuery, queryTableRequest.fullTextQuery) && Objects.equals(this.k, queryTableRequest.k) && Objects.equals(this.lowerBound, queryTableRequest.lowerBound) && Objects.equals(this.nprobes, queryTableRequest.nprobes) && Objects.equals(this.offset, queryTableRequest.offset) && Objects.equals(this.prefilter, queryTableRequest.prefilter) && Objects.equals(this.refineFactor, queryTableRequest.refineFactor) && Objects.equals(this.upperBound, queryTableRequest.upperBound) && Objects.equals(this.vector, queryTableRequest.vector) && Objects.equals(this.vectorColumn, queryTableRequest.vectorColumn) && Objects.equals(this.version, queryTableRequest.version) && Objects.equals(this.withRowId, queryTableRequest.withRowId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.bypassVectorIndex, this.columns, this.distanceType, this.ef, this.fastSearch, this.filter, this.fullTextQuery, this.k, this.lowerBound, this.nprobes, this.offset, this.prefilter, this.refineFactor, this.upperBound, this.vector, this.vectorColumn, this.version, this.withRowId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryTableRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    bypassVectorIndex: ").append(this.toIndentedString(this.bypassVectorIndex)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    distanceType: ").append(this.toIndentedString(this.distanceType)).append("\n");
        sb.append("    ef: ").append(this.toIndentedString(this.ef)).append("\n");
        sb.append("    fastSearch: ").append(this.toIndentedString(this.fastSearch)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    fullTextQuery: ").append(this.toIndentedString(this.fullTextQuery)).append("\n");
        sb.append("    k: ").append(this.toIndentedString(this.k)).append("\n");
        sb.append("    lowerBound: ").append(this.toIndentedString(this.lowerBound)).append("\n");
        sb.append("    nprobes: ").append(this.toIndentedString(this.nprobes)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    prefilter: ").append(this.toIndentedString(this.prefilter)).append("\n");
        sb.append("    refineFactor: ").append(this.toIndentedString(this.refineFactor)).append("\n");
        sb.append("    upperBound: ").append(this.toIndentedString(this.upperBound)).append("\n");
        sb.append("    vector: ").append(this.toIndentedString(this.vector)).append("\n");
        sb.append("    vectorColumn: ").append(this.toIndentedString(this.vectorColumn)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    withRowId: ").append(this.toIndentedString(this.withRowId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

