/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RegisterTableRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private String location;
    private ModeEnum mode;
    @Valid
    private Map<String, String> properties = new HashMap<String, String>();

    public RegisterTableRequest() {
    }

    public RegisterTableRequest(String location) {
        this.location = location;
    }

    public RegisterTableRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public RegisterTableRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public RegisterTableRequest location(String location) {
        this.location = location;
        return this;
    }

    @NotNull
    @Schema(name="location", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public RegisterTableRequest mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Schema(name="mode", description="There are two modes when trying to register a table, to differentiate the behavior when a table of the same name already exists:   * CREATE (default): the operation fails with 409.   * OVERWRITE: the existing table registration is replaced with the new registration. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="mode")
    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public RegisterTableRequest properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public RegisterTableRequest putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Schema(name="properties", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterTableRequest registerTableRequest = (RegisterTableRequest)o;
        return Objects.equals(this.id, registerTableRequest.id) && Objects.equals(this.location, registerTableRequest.location) && Objects.equals((Object)this.mode, (Object)registerTableRequest.mode) && Objects.equals(this.properties, registerTableRequest.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.location, this.mode, this.properties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegisterTableRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ModeEnum {
        CREATE("CREATE"),
        OVERWRITE("OVERWRITE");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

