/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.api;

import com.lancedb.lance.namespace.server.springboot.api.ApiUtil;
import com.lancedb.lance.namespace.server.springboot.model.AlterTableAddColumnsRequest;
import com.lancedb.lance.namespace.server.springboot.model.AlterTableAddColumnsResponse;
import com.lancedb.lance.namespace.server.springboot.model.AlterTableAlterColumnsRequest;
import com.lancedb.lance.namespace.server.springboot.model.AlterTableAlterColumnsResponse;
import com.lancedb.lance.namespace.server.springboot.model.AlterTableDropColumnsRequest;
import com.lancedb.lance.namespace.server.springboot.model.AlterTableDropColumnsResponse;
import com.lancedb.lance.namespace.server.springboot.model.AnalyzeTableQueryPlanRequest;
import com.lancedb.lance.namespace.server.springboot.model.AnalyzeTableQueryPlanResponse;
import com.lancedb.lance.namespace.server.springboot.model.CountTableRowsRequest;
import com.lancedb.lance.namespace.server.springboot.model.CreateEmptyTableRequest;
import com.lancedb.lance.namespace.server.springboot.model.CreateEmptyTableResponse;
import com.lancedb.lance.namespace.server.springboot.model.CreateTableIndexRequest;
import com.lancedb.lance.namespace.server.springboot.model.CreateTableIndexResponse;
import com.lancedb.lance.namespace.server.springboot.model.CreateTableResponse;
import com.lancedb.lance.namespace.server.springboot.model.CreateTableTagRequest;
import com.lancedb.lance.namespace.server.springboot.model.DeleteFromTableRequest;
import com.lancedb.lance.namespace.server.springboot.model.DeleteFromTableResponse;
import com.lancedb.lance.namespace.server.springboot.model.DeleteTableTagRequest;
import com.lancedb.lance.namespace.server.springboot.model.DeregisterTableRequest;
import com.lancedb.lance.namespace.server.springboot.model.DeregisterTableResponse;
import com.lancedb.lance.namespace.server.springboot.model.DescribeTableIndexStatsRequest;
import com.lancedb.lance.namespace.server.springboot.model.DescribeTableIndexStatsResponse;
import com.lancedb.lance.namespace.server.springboot.model.DescribeTableRequest;
import com.lancedb.lance.namespace.server.springboot.model.DescribeTableResponse;
import com.lancedb.lance.namespace.server.springboot.model.DropTableIndexRequest;
import com.lancedb.lance.namespace.server.springboot.model.DropTableIndexResponse;
import com.lancedb.lance.namespace.server.springboot.model.DropTableRequest;
import com.lancedb.lance.namespace.server.springboot.model.DropTableResponse;
import com.lancedb.lance.namespace.server.springboot.model.ErrorResponse;
import com.lancedb.lance.namespace.server.springboot.model.ExplainTableQueryPlanRequest;
import com.lancedb.lance.namespace.server.springboot.model.ExplainTableQueryPlanResponse;
import com.lancedb.lance.namespace.server.springboot.model.GetTableStatsRequest;
import com.lancedb.lance.namespace.server.springboot.model.GetTableStatsResponse;
import com.lancedb.lance.namespace.server.springboot.model.GetTableTagVersionRequest;
import com.lancedb.lance.namespace.server.springboot.model.GetTableTagVersionResponse;
import com.lancedb.lance.namespace.server.springboot.model.InsertIntoTableResponse;
import com.lancedb.lance.namespace.server.springboot.model.ListTableIndicesRequest;
import com.lancedb.lance.namespace.server.springboot.model.ListTableIndicesResponse;
import com.lancedb.lance.namespace.server.springboot.model.ListTableTagsResponse;
import com.lancedb.lance.namespace.server.springboot.model.ListTableVersionsRequest;
import com.lancedb.lance.namespace.server.springboot.model.ListTableVersionsResponse;
import com.lancedb.lance.namespace.server.springboot.model.MergeInsertIntoTableResponse;
import com.lancedb.lance.namespace.server.springboot.model.QueryTableRequest;
import com.lancedb.lance.namespace.server.springboot.model.RegisterTableRequest;
import com.lancedb.lance.namespace.server.springboot.model.RegisterTableResponse;
import com.lancedb.lance.namespace.server.springboot.model.RestoreTableRequest;
import com.lancedb.lance.namespace.server.springboot.model.RestoreTableResponse;
import com.lancedb.lance.namespace.server.springboot.model.TableExistsRequest;
import com.lancedb.lance.namespace.server.springboot.model.UpdateTableRequest;
import com.lancedb.lance.namespace.server.springboot.model.UpdateTableResponse;
import com.lancedb.lance.namespace.server.springboot.model.UpdateTableTagRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Tag(name="Table", description="Operations that are related to a table ")
public interface TableApi {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    @Operation(operationId="alterTableAddColumns", summary="Add new columns to table schema", description="Add new columns to table `id` using SQL expressions or default values. ", tags={"Table", "Data"}, responses={@ApiResponse(responseCode="200", description="Add columns operation result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlterTableAddColumnsResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/add_columns"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<AlterTableAddColumnsResponse> alterTableAddColumns(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="AlterTableAddColumnsRequest", description="", required=true) @Valid @RequestBody AlterTableAddColumnsRequest alterTableAddColumnsRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"version\" : 0 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="alterTableAlterColumns", summary="Modify existing columns", description="Modify existing columns in table `id`, such as renaming or changing data types. ", tags={"Table", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Alter columns operation result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlterTableAlterColumnsResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/alter_columns"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<AlterTableAlterColumnsResponse> alterTableAlterColumns(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="AlterTableAlterColumnsRequest", description="", required=true) @Valid @RequestBody AlterTableAlterColumnsRequest alterTableAlterColumnsRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"version\" : 0 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="alterTableDropColumns", summary="Remove columns from table", description="Remove specified columns from table `id`. ", tags={"Table", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Drop columns operation result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlterTableDropColumnsResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/drop_columns"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<AlterTableDropColumnsResponse> alterTableDropColumns(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="AlterTableDropColumnsRequest", description="", required=true) @Valid @RequestBody AlterTableDropColumnsRequest alterTableDropColumnsRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"version\" : 0 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="analyzeTableQueryPlan", summary="Analyze query execution plan", description="Analyze the query execution plan for a query against table `id`. Returns detailed statistics and analysis of the query execution plan. ", tags={"Table", "Data"}, responses={@ApiResponse(responseCode="200", description="Query execution plan analysis", content={@Content(mediaType="application/json", schema=@Schema(implementation=AnalyzeTableQueryPlanResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/analyze_plan"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<AnalyzeTableQueryPlanResponse> analyzeTableQueryPlan(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="AnalyzeTableQueryPlanRequest", description="", required=true) @Valid @RequestBody AnalyzeTableQueryPlanRequest analyzeTableQueryPlanRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"analysis\" : \"analysis\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="countTableRows", summary="Count rows in a table", description="Count the number of rows in table `id` ", tags={"Table", "Data"}, responses={@ApiResponse(responseCode="200", description="Result of counting rows in a table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Long.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/count_rows"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<Long> countTableRows(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="CountTableRowsRequest", description="", required=true) @Valid @RequestBody CountTableRowsRequest countTableRowsRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="createEmptyTable", summary="Create an empty table", description="Create an empty table with the given name without touching storage. This is a metadata-only operation that records the table existence and sets up aspects like access control.  For DirectoryNamespace implementation, this creates a `.lance-reserved` file in the table directory to mark the table's existence without creating actual Lance data files. ", tags={"Table", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Table properties result when creating an empty table", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateEmptyTableResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="The request conflicts with the current state of the target resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/create-empty"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<CreateEmptyTableResponse> createEmptyTable(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="CreateEmptyTableRequest", description="", required=true) @Valid @RequestBody CreateEmptyTableRequest createEmptyTableRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"location\" : \"location\", \"properties\" : { \"key\" : \"properties\" }, \"storage_options\" : { \"key\" : \"storage_options\" } }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="createTable", summary="Create a table with the given name", description="Create table `id` in the namespace with the given data in Arrow IPC stream.  The schema of the Arrow IPC stream is used as the table schema.     If the stream is empty, the API creates a new empty table.  REST NAMESPACE ONLY REST namespace uses Arrow IPC stream as the request body. It passes in the `CreateTableRequest` information in the following way: - `id`: pass through path parameter of the same name - `mode`: pass through query parameter of the same name - `location`: pass through header `x-lance-table-location` - `properties`: pass through header `x-lance-table-properties` ", tags={"Table", "Data"}, responses={@ApiResponse(responseCode="200", description="Table properties result when creating a table", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateTableResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/create"}, produces={"application/json"}, consumes={"application/vnd.apache.arrow.stream"})
    default public ResponseEntity<CreateTableResponse> createTable(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="body", description="Arrow IPC data", required=true) @Valid @RequestBody Resource body, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter, @Parameter(name="mode", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="mode", required=false) Optional<String> mode, @Parameter(name="x-lance-table-location", description="URI pointing to root location to create the table at", in=ParameterIn.HEADER) @RequestHeader(value="x-lance-table-location", required=false) Optional<String> xLanceTableLocation, @Parameter(name="x-lance-table-properties", description="JSON-encoded string map (e.g. { \"owner\": \"jack\" }) ", in=ParameterIn.HEADER) @RequestHeader(value="x-lance-table-properties", required=false) Optional<String> xLanceTableProperties) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"location\" : \"location\", \"version\" : 0, \"properties\" : { \"key\" : \"properties\" }, \"storage_options\" : { \"key\" : \"storage_options\" } }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="createTableIndex", summary="Create an index on a table", description="Create an index on a table column for faster search operations. Supports vector indexes (IVF_FLAT, IVF_HNSW_SQ, IVF_PQ, etc.) and scalar indexes (BTREE, BITMAP, FTS, etc.). Index creation is handled asynchronously.  Use the `ListTableIndices` and `DescribeTableIndexStats` operations to monitor index creation progress. ", tags={"Table", "Index", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Index created successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateTableIndexResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/create_index"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<CreateTableIndexResponse> createTableIndex(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="CreateTableIndexRequest", description="Index creation request", required=true) @Valid @RequestBody CreateTableIndexRequest createTableIndexRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"location\" : \"location\", \"id\" : [ \"id\", \"id\" ], \"properties\" : { \"key\" : \"properties\" } }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="createTableTag", summary="Create a new tag", description="Create a new tag for table `id` that points to a specific version. ", tags={"Table", "Tag", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Success, no content"), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="The request conflicts with the current state of the target resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/tags/create"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<Void> createTableTag(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="CreateTableTagRequest", description="", required=true) @Valid @RequestBody CreateTableTagRequest createTableTagRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteFromTable", summary="Delete rows from a table", description="Delete rows from table `id`. ", tags={"Table", "Data"}, responses={@ApiResponse(responseCode="200", description="Delete successful", content={@Content(mediaType="application/json", schema=@Schema(implementation=DeleteFromTableResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/delete"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<DeleteFromTableResponse> deleteFromTable(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="DeleteFromTableRequest", description="Delete request", required=true) @Valid @RequestBody DeleteFromTableRequest deleteFromTableRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"version\" : 0 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteTableTag", summary="Delete a tag", description="Delete an existing tag from table `id`. ", tags={"Table", "Tag", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Success, no content"), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/tags/delete"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<Void> deleteTableTag(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="DeleteTableTagRequest", description="", required=true) @Valid @RequestBody DeleteTableTagRequest deleteTableTagRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deregisterTable", summary="Deregister a table", description="Deregister table `id` from its namespace. ", tags={"Table", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Response of DeregisterTable", content={@Content(mediaType="application/json", schema=@Schema(implementation=DeregisterTableResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/deregister"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<DeregisterTableResponse> deregisterTable(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="DeregisterTableRequest", description="", required=true) @Valid @RequestBody DeregisterTableRequest deregisterTableRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"location\" : \"location\", \"id\" : [ \"id\", \"id\" ], \"properties\" : { \"key\" : \"properties\" } }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="describeTable", summary="Describe information of a table", description="Describe the detailed information for table `id`. ", tags={"Table", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Table properties result when loading a table", content={@Content(mediaType="application/json", schema=@Schema(implementation=DescribeTableResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/describe"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<DescribeTableResponse> describeTable(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="DescribeTableRequest", description="", required=true) @Valid @RequestBody DescribeTableRequest describeTableRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"schema\" : { \"metadata\" : { \"key\" : \"metadata\" }, \"fields\" : [ { \"metadata\" : { \"key\" : \"metadata\" }, \"nullable\" : true, \"name\" : \"name\", \"type\" : { \"length\" : 0, \"fields\" : [ null, null ], \"type\" : \"type\" } }, { \"metadata\" : { \"key\" : \"metadata\" }, \"nullable\" : true, \"name\" : \"name\", \"type\" : { \"length\" : 0, \"fields\" : [ null, null ], \"type\" : \"type\" } } ] }, \"location\" : \"location\", \"version\" : 0, \"properties\" : { \"key\" : \"properties\" }, \"storage_options\" : { \"key\" : \"storage_options\" } }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="describeTableIndexStats", summary="Get table index statistics", description="Get statistics for a specific index on a table. Returns information about the index type, distance type (for vector indices), and row counts. ", tags={"Table", "Index", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Index statistics", content={@Content(mediaType="application/json", schema=@Schema(implementation=DescribeTableIndexStatsResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/index/{index_name}/stats"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<DescribeTableIndexStatsResponse> describeTableIndexStats(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="index_name", description="Name of the index to get stats for", required=true, in=ParameterIn.PATH) @PathVariable(value="index_name") String indexName, @Parameter(name="DescribeTableIndexStatsRequest", description="Index stats request", required=true) @Valid @RequestBody DescribeTableIndexStatsRequest describeTableIndexStatsRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"distance_type\" : \"distance_type\", \"num_unindexed_rows\" : 0, \"num_indexed_rows\" : 0, \"index_type\" : \"index_type\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="dropTable", summary="Drop a table", description="Drop table `id` and delete its data. ", tags={"Table", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Response of DropTable", content={@Content(mediaType="application/json", schema=@Schema(implementation=DropTableResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/drop"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<DropTableResponse> dropTable(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="DropTableRequest", description="", required=true) @Valid @RequestBody DropTableRequest dropTableRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"location\" : \"location\", \"id\" : [ \"id\", \"id\" ], \"properties\" : { \"key\" : \"properties\" }, \"transactionId\" : [ \"transactionId\", \"transactionId\" ] }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="dropTableIndex", summary="Drop a specific index", description="Drop the specified index from table `id`. ", tags={"Table", "Index", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Index drop operation result", content={@Content(mediaType="application/json", schema=@Schema(implementation=DropTableIndexResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/index/{index_name}/drop"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<DropTableIndexResponse> dropTableIndex(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="index_name", description="Name of the index to drop", required=true, in=ParameterIn.PATH) @PathVariable(value="index_name") String indexName, @Parameter(name="DropTableIndexRequest", description="", required=true) @Valid @RequestBody DropTableIndexRequest dropTableIndexRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"version\" : 0 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="explainTableQueryPlan", summary="Get query execution plan explanation", description="Get the query execution plan for a query against table `id`. Returns a human-readable explanation of how the query will be executed. ", tags={"Table", "Data"}, responses={@ApiResponse(responseCode="200", description="Query execution plan explanation", content={@Content(mediaType="application/json", schema=@Schema(implementation=ExplainTableQueryPlanResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/explain_plan"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<ExplainTableQueryPlanResponse> explainTableQueryPlan(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="ExplainTableQueryPlanRequest", description="", required=true) @Valid @RequestBody ExplainTableQueryPlanRequest explainTableQueryPlanRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"plan\" : \"plan\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getTableStats", summary="Get table statistics", description="Get statistics for table `id`, including row counts, data sizes, and column statistics. ", tags={"Table", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Table statistics", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetTableStatsResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/stats"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<GetTableStatsResponse> getTableStats(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="GetTableStatsRequest", description="", required=true) @Valid @RequestBody GetTableStatsRequest getTableStatsRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"size_bytes\" : 0, \"num_rows\" : 0, \"num_fragments\" : 0 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getTableTagVersion", summary="Get version for a specific tag", description="Get the version number that a specific tag points to for table `id`. ", tags={"Table", "Tag", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Tag version information", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetTableTagVersionResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/tags/version"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<GetTableTagVersionResponse> getTableTagVersion(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="GetTableTagVersionRequest", description="", required=true) @Valid @RequestBody GetTableTagVersionRequest getTableTagVersionRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"version\" : 0 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="insertIntoTable", summary="Insert records into a table", description="Insert new records into table `id`.  REST NAMESPACE ONLY REST namespace uses Arrow IPC stream as the request body. It passes in the `InsertIntoTableRequest` information in the following way: - `id`: pass through path parameter of the same name - `mode`: pass through query parameter of the same name ", tags={"Table", "Data"}, responses={@ApiResponse(responseCode="200", description="Result of inserting records into a table", content={@Content(mediaType="application/json", schema=@Schema(implementation=InsertIntoTableResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/insert"}, produces={"application/json"}, consumes={"application/vnd.apache.arrow.stream"})
    default public ResponseEntity<InsertIntoTableResponse> insertIntoTable(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="body", description="Arrow IPC stream containing the records to insert", required=true) @Valid @RequestBody Resource body, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter, @Parameter(name="mode", description="How the insert should behave: - append (default): insert data to the existing table - overwrite: remove all data in the table and then insert data to it ", in=ParameterIn.QUERY) @Valid @RequestParam(value="mode", required=false, defaultValue="append") Optional<String> mode) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"version\" : 0 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="listTableIndices", summary="List indexes on a table", description="List all indices created on a table. Returns information about each index including name, columns, status, and UUID. ", tags={"Table", "Index", "Metadata"}, responses={@ApiResponse(responseCode="200", description="List of indices on the table", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListTableIndicesResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/index/list"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<ListTableIndicesResponse> listTableIndices(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="ListTableIndicesRequest", description="Index list request", required=true) @Valid @RequestBody ListTableIndicesRequest listTableIndicesRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"indexes\" : [ { \"index_uuid\" : \"index_uuid\", \"columns\" : [ \"columns\", \"columns\" ], \"index_name\" : \"index_name\", \"status\" : \"status\" }, { \"index_uuid\" : \"index_uuid\", \"columns\" : [ \"columns\", \"columns\" ], \"index_name\" : \"index_name\", \"status\" : \"status\" } ], \"page_token\" : \"page_token\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="listTableTags", summary="List all tags for a table", description="List all tags that have been created for table `id`. Returns a map of tag names to their corresponding version numbers and metadata.  REST NAMESPACE ONLY REST namespace uses GET to perform this operation without a request body. It passes in the `ListTableTagsRequest` information in the following way: - `id`: pass through path parameter of the same name - `page_token`: pass through query parameter of the same name - `limit`: pass through query parameter of the same name ", tags={"Table", "Tag", "Metadata"}, responses={@ApiResponse(responseCode="200", description="List of table tags", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListTableTagsResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/v1/table/{id}/tags/list"}, produces={"application/json"})
    default public ResponseEntity<ListTableTagsResponse> listTableTags(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter, @Parameter(name="page_token", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="page_token", required=false) Optional<String> pageToken, @Parameter(name="limit", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="limit", required=false) Optional<Integer> limit) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"tags\" : { \"key\" : { \"version\" : 0 } } }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="listTableVersions", summary="List all versions of a table", description="List all versions (commits) of table `id` with their metadata. ", tags={"Table", "Metadata"}, responses={@ApiResponse(responseCode="200", description="List of table versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListTableVersionsResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/version/list"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<ListTableVersionsResponse> listTableVersions(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="ListTableVersionsRequest", description="", required=true) @Valid @RequestBody ListTableVersionsRequest listTableVersionsRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"versions\" : [ { \"version\" : 0, \"timestamp\" : \"2000-01-23T04:56:07.000+00:00\" }, { \"version\" : 0, \"timestamp\" : \"2000-01-23T04:56:07.000+00:00\" } ], \"page_token\" : \"page_token\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="mergeInsertIntoTable", summary="Merge insert (upsert) records into a table", description="Performs a merge insert (upsert) operation on table `id`. This operation updates existing rows based on a matching column and inserts new rows that don't match. It returns the number of rows inserted and updated.  REST NAMESPACE ONLY REST namespace uses Arrow IPC stream as the request body. It passes in the `MergeInsertIntoTableRequest` information in the following way: - `id`: pass through path parameter of the same name - `on`: pass through query parameter of the same name - `when_matched_update_all`: pass through query parameter of the same name - `when_matched_update_all_filt`: pass through query parameter of the same name - `when_not_matched_insert_all`: pass through query parameter of the same name - `when_not_matched_by_source_delete`: pass through query parameter of the same name - `when_not_matched_by_source_delete_filt`: pass through query parameter of the same name ", tags={"Table", "Data"}, responses={@ApiResponse(responseCode="200", description="Result of merge insert operation", content={@Content(mediaType="application/json", schema=@Schema(implementation=MergeInsertIntoTableResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/merge_insert"}, produces={"application/json"}, consumes={"application/vnd.apache.arrow.stream"})
    default public ResponseEntity<MergeInsertIntoTableResponse> mergeInsertIntoTable(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @NotNull @Parameter(name="on", description="Column name to use for matching rows (required)", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="on", required=true) String on, @Parameter(name="body", description="Arrow IPC stream containing the records to merge", required=true) @Valid @RequestBody Resource body, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter, @Parameter(name="when_matched_update_all", description="Update all columns when rows match", in=ParameterIn.QUERY) @Valid @RequestParam(value="when_matched_update_all", required=false, defaultValue="false") Optional<Boolean> whenMatchedUpdateAll, @Parameter(name="when_matched_update_all_filt", description="The row is updated (similar to UpdateAll) only for rows where the SQL expression evaluates to true", in=ParameterIn.QUERY) @Valid @RequestParam(value="when_matched_update_all_filt", required=false) Optional<String> whenMatchedUpdateAllFilt, @Parameter(name="when_not_matched_insert_all", description="Insert all columns when rows don't match", in=ParameterIn.QUERY) @Valid @RequestParam(value="when_not_matched_insert_all", required=false, defaultValue="false") Optional<Boolean> whenNotMatchedInsertAll, @Parameter(name="when_not_matched_by_source_delete", description="Delete all rows from target table that don't match a row in the source table", in=ParameterIn.QUERY) @Valid @RequestParam(value="when_not_matched_by_source_delete", required=false, defaultValue="false") Optional<Boolean> whenNotMatchedBySourceDelete, @Parameter(name="when_not_matched_by_source_delete_filt", description="Delete rows from the target table if there is no match AND the SQL expression evaluates to true", in=ParameterIn.QUERY) @Valid @RequestParam(value="when_not_matched_by_source_delete_filt", required=false) Optional<String> whenNotMatchedBySourceDeleteFilt) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"num_inserted_rows\" : 0, \"num_updated_rows\" : 0, \"num_deleted_rows\" : 0, \"version\" : 0 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="queryTable", summary="Query a table", description="Query table `id` with vector search, full text search and optional SQL filtering. Returns results in Arrow IPC file or stream format. ", tags={"Table", "Data"}, responses={@ApiResponse(responseCode="200", description="Query results in Arrow IPC file or stream format", content={@Content(mediaType="application/vnd.apache.arrow.file", schema=@Schema(implementation=Resource.class)), @Content(mediaType="application/vnd.apache.arrow.stream", schema=@Schema(implementation=Resource.class)), @Content(mediaType="application/json", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/vnd.apache.arrow.file", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/vnd.apache.arrow.stream", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/vnd.apache.arrow.file", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/vnd.apache.arrow.stream", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/vnd.apache.arrow.file", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/vnd.apache.arrow.stream", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/vnd.apache.arrow.file", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/vnd.apache.arrow.stream", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/vnd.apache.arrow.file", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/vnd.apache.arrow.stream", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/vnd.apache.arrow.file", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/vnd.apache.arrow.stream", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/query"}, produces={"application/vnd.apache.arrow.file", "application/vnd.apache.arrow.stream", "application/json"}, consumes={"application/json"})
    default public ResponseEntity<Resource> queryTable(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="QueryTableRequest", description="Query request", required=true) @Valid @RequestBody QueryTableRequest queryTableRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="registerTable", summary="Register a table to a namespace", description="Register an existing table at a given storage location as `id`. ", tags={"Table", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Table properties result when registering a table", content={@Content(mediaType="application/json", schema=@Schema(implementation=RegisterTableResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="406", description="Not Acceptable / Unsupported Operation. The server does not support this operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="The request conflicts with the current state of the target resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/register"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<RegisterTableResponse> registerTable(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="RegisterTableRequest", description="", required=true) @Valid @RequestBody RegisterTableRequest registerTableRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"location\" : \"location\", \"properties\" : { \"key\" : \"properties\" } }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="restoreTable", summary="Restore table to a specific version", description="Restore table `id` to a specific version. ", tags={"Table", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Table restore operation result", content={@Content(mediaType="application/json", schema=@Schema(implementation=RestoreTableResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/restore"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<RestoreTableResponse> restoreTable(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="RestoreTableRequest", description="", required=true) @Valid @RequestBody RestoreTableRequest restoreTableRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"version\" : 0 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="tableExists", summary="Check if a table exists", description="Check if table `id` exists.  This operation should behave exactly like DescribeTable,  except it does not contain a response body.  For DirectoryNamespace implementation, a table exists if either: - The table has Lance data versions (regular table created with CreateTable) - A `.lance-reserved` file exists in the table directory (empty table created with CreateEmptyTable) ", tags={"Table", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Success, no content"), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/exists"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<Void> tableExists(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="TableExistsRequest", description="", required=true) @Valid @RequestBody TableExistsRequest tableExistsRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updateTable", summary="Update rows in a table", description="Update existing rows in table `id`. ", tags={"Table", "Data"}, responses={@ApiResponse(responseCode="200", description="Update successful", content={@Content(mediaType="application/json", schema=@Schema(implementation=UpdateTableResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/update"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<UpdateTableResponse> updateTable(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="UpdateTableRequest", description="Update request", required=true) @Valid @RequestBody UpdateTableRequest updateTableRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"updated_rows\" : 0, \"version\" : 0 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updateTableTag", summary="Update a tag to point to a different version", description="Update an existing tag for table `id` to point to a different version. ", tags={"Table", "Tag", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Success, no content"), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/table/{id}/tags/update"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<Void> updateTableTag(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="UpdateTableTagRequest", description="", required=true) @Valid @RequestBody UpdateTableTagRequest updateTableTagRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

