/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.lancedb.lance.namespace.server.springboot.model.NewColumnTransform;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AlterTableAddColumnsRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    @Valid
    private @Valid List<@Valid NewColumnTransform> newColumns = new ArrayList<NewColumnTransform>();

    public AlterTableAddColumnsRequest() {
    }

    public AlterTableAddColumnsRequest(List<@Valid NewColumnTransform> newColumns) {
        this.newColumns = newColumns;
    }

    public AlterTableAddColumnsRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public AlterTableAddColumnsRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public AlterTableAddColumnsRequest newColumns(List<@Valid NewColumnTransform> newColumns) {
        this.newColumns = newColumns;
        return this;
    }

    public AlterTableAddColumnsRequest addNewColumnsItem(NewColumnTransform newColumnsItem) {
        if (this.newColumns == null) {
            this.newColumns = new ArrayList<NewColumnTransform>();
        }
        this.newColumns.add(newColumnsItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="new_columns", description="List of new columns to add", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="new_columns")
    public @NotNull @Valid List<@Valid NewColumnTransform> getNewColumns() {
        return this.newColumns;
    }

    public void setNewColumns(List<@Valid NewColumnTransform> newColumns) {
        this.newColumns = newColumns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlterTableAddColumnsRequest alterTableAddColumnsRequest = (AlterTableAddColumnsRequest)o;
        return Objects.equals(this.id, alterTableAddColumnsRequest.id) && Objects.equals(this.newColumns, alterTableAddColumnsRequest.newColumns);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.newColumns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlterTableAddColumnsRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    newColumns: ").append(this.toIndentedString(this.newColumns)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

