/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CountTableRowsRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private Long version;
    private String filter;

    public CountTableRowsRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public CountTableRowsRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public CountTableRowsRequest version(Long version) {
        this.version = version;
        return this;
    }

    @Min(value=0L)
    @Schema(name="version", description="Version of the table to describe. If not specified, server should resolve it to the latest version. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public @Min(value=0L) Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public CountTableRowsRequest filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Schema(name="filter", description="SQL filter expression to be applied ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="filter")
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountTableRowsRequest countTableRowsRequest = (CountTableRowsRequest)o;
        return Objects.equals(this.id, countTableRowsRequest.id) && Objects.equals(this.version, countTableRowsRequest.version) && Objects.equals(this.filter, countTableRowsRequest.filter);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.filter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CountTableRowsRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

