/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateTableIndexRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private String column;
    private IndexTypeEnum indexType;
    private MetricTypeEnum metricType;
    private Boolean withPosition;
    private String baseTokenizer;
    private String language;
    private Integer maxTokenLength;
    private Boolean lowerCase;
    private Boolean stem;
    private Boolean removeStopWords;
    private Boolean asciiFolding;

    public CreateTableIndexRequest() {
    }

    public CreateTableIndexRequest(String column, IndexTypeEnum indexType) {
        this.column = column;
        this.indexType = indexType;
    }

    public CreateTableIndexRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public CreateTableIndexRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public CreateTableIndexRequest column(String column) {
        this.column = column;
        return this;
    }

    @NotNull
    @Schema(name="column", description="Name of the column to create index on", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="column")
    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public CreateTableIndexRequest indexType(IndexTypeEnum indexType) {
        this.indexType = indexType;
        return this;
    }

    @NotNull
    @Schema(name="index_type", description="Type of index to create", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="index_type")
    public IndexTypeEnum getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexTypeEnum indexType) {
        this.indexType = indexType;
    }

    public CreateTableIndexRequest metricType(MetricTypeEnum metricType) {
        this.metricType = metricType;
        return this;
    }

    @Schema(name="metric_type", description="Distance metric type for vector indexes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="metric_type")
    public MetricTypeEnum getMetricType() {
        return this.metricType;
    }

    public void setMetricType(MetricTypeEnum metricType) {
        this.metricType = metricType;
    }

    public CreateTableIndexRequest withPosition(Boolean withPosition) {
        this.withPosition = withPosition;
        return this;
    }

    @Schema(name="with_position", description="Optional FTS parameter for position tracking", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="with_position")
    public Boolean getWithPosition() {
        return this.withPosition;
    }

    public void setWithPosition(Boolean withPosition) {
        this.withPosition = withPosition;
    }

    public CreateTableIndexRequest baseTokenizer(String baseTokenizer) {
        this.baseTokenizer = baseTokenizer;
        return this;
    }

    @Schema(name="base_tokenizer", description="Optional FTS parameter for base tokenizer", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="base_tokenizer")
    public String getBaseTokenizer() {
        return this.baseTokenizer;
    }

    public void setBaseTokenizer(String baseTokenizer) {
        this.baseTokenizer = baseTokenizer;
    }

    public CreateTableIndexRequest language(String language) {
        this.language = language;
        return this;
    }

    @Schema(name="language", description="Optional FTS parameter for language", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public CreateTableIndexRequest maxTokenLength(Integer maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
        return this;
    }

    @Min(value=0L)
    @Schema(name="max_token_length", description="Optional FTS parameter for maximum token length", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="max_token_length")
    public @Min(value=0L) Integer getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public void setMaxTokenLength(Integer maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
    }

    public CreateTableIndexRequest lowerCase(Boolean lowerCase) {
        this.lowerCase = lowerCase;
        return this;
    }

    @Schema(name="lower_case", description="Optional FTS parameter for lowercase conversion", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="lower_case")
    public Boolean getLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(Boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public CreateTableIndexRequest stem(Boolean stem) {
        this.stem = stem;
        return this;
    }

    @Schema(name="stem", description="Optional FTS parameter for stemming", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="stem")
    public Boolean getStem() {
        return this.stem;
    }

    public void setStem(Boolean stem) {
        this.stem = stem;
    }

    public CreateTableIndexRequest removeStopWords(Boolean removeStopWords) {
        this.removeStopWords = removeStopWords;
        return this;
    }

    @Schema(name="remove_stop_words", description="Optional FTS parameter for stop word removal", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="remove_stop_words")
    public Boolean getRemoveStopWords() {
        return this.removeStopWords;
    }

    public void setRemoveStopWords(Boolean removeStopWords) {
        this.removeStopWords = removeStopWords;
    }

    public CreateTableIndexRequest asciiFolding(Boolean asciiFolding) {
        this.asciiFolding = asciiFolding;
        return this;
    }

    @Schema(name="ascii_folding", description="Optional FTS parameter for ASCII folding", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="ascii_folding")
    public Boolean getAsciiFolding() {
        return this.asciiFolding;
    }

    public void setAsciiFolding(Boolean asciiFolding) {
        this.asciiFolding = asciiFolding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTableIndexRequest createTableIndexRequest = (CreateTableIndexRequest)o;
        return Objects.equals(this.id, createTableIndexRequest.id) && Objects.equals(this.column, createTableIndexRequest.column) && Objects.equals((Object)this.indexType, (Object)createTableIndexRequest.indexType) && Objects.equals((Object)this.metricType, (Object)createTableIndexRequest.metricType) && Objects.equals(this.withPosition, createTableIndexRequest.withPosition) && Objects.equals(this.baseTokenizer, createTableIndexRequest.baseTokenizer) && Objects.equals(this.language, createTableIndexRequest.language) && Objects.equals(this.maxTokenLength, createTableIndexRequest.maxTokenLength) && Objects.equals(this.lowerCase, createTableIndexRequest.lowerCase) && Objects.equals(this.stem, createTableIndexRequest.stem) && Objects.equals(this.removeStopWords, createTableIndexRequest.removeStopWords) && Objects.equals(this.asciiFolding, createTableIndexRequest.asciiFolding);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.column, this.indexType, this.metricType, this.withPosition, this.baseTokenizer, this.language, this.maxTokenLength, this.lowerCase, this.stem, this.removeStopWords, this.asciiFolding});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTableIndexRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    column: ").append(this.toIndentedString(this.column)).append("\n");
        sb.append("    indexType: ").append(this.toIndentedString((Object)this.indexType)).append("\n");
        sb.append("    metricType: ").append(this.toIndentedString((Object)this.metricType)).append("\n");
        sb.append("    withPosition: ").append(this.toIndentedString(this.withPosition)).append("\n");
        sb.append("    baseTokenizer: ").append(this.toIndentedString(this.baseTokenizer)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    maxTokenLength: ").append(this.toIndentedString(this.maxTokenLength)).append("\n");
        sb.append("    lowerCase: ").append(this.toIndentedString(this.lowerCase)).append("\n");
        sb.append("    stem: ").append(this.toIndentedString(this.stem)).append("\n");
        sb.append("    removeStopWords: ").append(this.toIndentedString(this.removeStopWords)).append("\n");
        sb.append("    asciiFolding: ").append(this.toIndentedString(this.asciiFolding)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum IndexTypeEnum {
        BTREE("BTREE"),
        BITMAP("BITMAP"),
        LABEL_LIST("LABEL_LIST"),
        IVF_FLAT("IVF_FLAT"),
        IVF_PQ("IVF_PQ"),
        IVF_HNSW_SQ("IVF_HNSW_SQ"),
        FTS("FTS");

        private String value;

        private IndexTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IndexTypeEnum fromValue(String value) {
            for (IndexTypeEnum b : IndexTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MetricTypeEnum {
        L2("l2"),
        COSINE("cosine"),
        DOT("dot");

        private String value;

        private MetricTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MetricTypeEnum fromValue(String value) {
            for (MetricTypeEnum b : MetricTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

