/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CreateTableResponse {
    private String location;
    private Long version;
    @Valid
    private Map<String, String> properties = new HashMap<String, String>();
    @Valid
    private Map<String, String> storageOptions = new HashMap<String, String>();

    public CreateTableResponse location(String location) {
        this.location = location;
        return this;
    }

    @Schema(name="location", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public CreateTableResponse version(Long version) {
        this.version = version;
        return this;
    }

    @Min(value=0L)
    @Schema(name="version", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public @Min(value=0L) Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public CreateTableResponse properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public CreateTableResponse putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Schema(name="properties", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public CreateTableResponse storageOptions(Map<String, String> storageOptions) {
        this.storageOptions = storageOptions;
        return this;
    }

    public CreateTableResponse putStorageOptionsItem(String key, String storageOptionsItem) {
        if (this.storageOptions == null) {
            this.storageOptions = new HashMap<String, String>();
        }
        this.storageOptions.put(key, storageOptionsItem);
        return this;
    }

    @Schema(name="storage_options", description="Configuration options to be used to access storage. The available options depend on the type of storage in use. These will be passed directly to Lance to initialize storage access. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="storage_options")
    public Map<String, String> getStorageOptions() {
        return this.storageOptions;
    }

    public void setStorageOptions(Map<String, String> storageOptions) {
        this.storageOptions = storageOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTableResponse createTableResponse = (CreateTableResponse)o;
        return Objects.equals(this.location, createTableResponse.location) && Objects.equals(this.version, createTableResponse.version) && Objects.equals(this.properties, createTableResponse.properties) && Objects.equals(this.storageOptions, createTableResponse.storageOptions);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.version, this.properties, this.storageOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTableResponse {\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    storageOptions: ").append(this.toIndentedString(this.storageOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

