/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DescribeTableIndexStatsRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private Long version;
    private String indexName;

    public DescribeTableIndexStatsRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public DescribeTableIndexStatsRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public DescribeTableIndexStatsRequest version(Long version) {
        this.version = version;
        return this;
    }

    @Min(value=0L)
    @Schema(name="version", description="Optional table version to get stats for", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public @Min(value=0L) Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public DescribeTableIndexStatsRequest indexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    @Schema(name="index_name", description="Name of the index", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="index_name")
    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescribeTableIndexStatsRequest describeTableIndexStatsRequest = (DescribeTableIndexStatsRequest)o;
        return Objects.equals(this.id, describeTableIndexStatsRequest.id) && Objects.equals(this.version, describeTableIndexStatsRequest.version) && Objects.equals(this.indexName, describeTableIndexStatsRequest.indexName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.indexName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DescribeTableIndexStatsRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    indexName: ").append(this.toIndentedString(this.indexName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

