/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import java.util.Objects;

public class DescribeTableIndexStatsResponse {
    private String distanceType;
    private String indexType;
    private Long numIndexedRows;
    private Long numUnindexedRows;

    public DescribeTableIndexStatsResponse distanceType(String distanceType) {
        this.distanceType = distanceType;
        return this;
    }

    @Schema(name="distance_type", description="Distance type for vector indexes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="distance_type")
    public String getDistanceType() {
        return this.distanceType;
    }

    public void setDistanceType(String distanceType) {
        this.distanceType = distanceType;
    }

    public DescribeTableIndexStatsResponse indexType(String indexType) {
        this.indexType = indexType;
        return this;
    }

    @Schema(name="index_type", description="Type of the index", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="index_type")
    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public DescribeTableIndexStatsResponse numIndexedRows(Long numIndexedRows) {
        this.numIndexedRows = numIndexedRows;
        return this;
    }

    @Min(value=0L)
    @Schema(name="num_indexed_rows", description="Number of indexed rows", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="num_indexed_rows")
    public @Min(value=0L) Long getNumIndexedRows() {
        return this.numIndexedRows;
    }

    public void setNumIndexedRows(Long numIndexedRows) {
        this.numIndexedRows = numIndexedRows;
    }

    public DescribeTableIndexStatsResponse numUnindexedRows(Long numUnindexedRows) {
        this.numUnindexedRows = numUnindexedRows;
        return this;
    }

    @Min(value=0L)
    @Schema(name="num_unindexed_rows", description="Number of unindexed rows", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="num_unindexed_rows")
    public @Min(value=0L) Long getNumUnindexedRows() {
        return this.numUnindexedRows;
    }

    public void setNumUnindexedRows(Long numUnindexedRows) {
        this.numUnindexedRows = numUnindexedRows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescribeTableIndexStatsResponse describeTableIndexStatsResponse = (DescribeTableIndexStatsResponse)o;
        return Objects.equals(this.distanceType, describeTableIndexStatsResponse.distanceType) && Objects.equals(this.indexType, describeTableIndexStatsResponse.indexType) && Objects.equals(this.numIndexedRows, describeTableIndexStatsResponse.numIndexedRows) && Objects.equals(this.numUnindexedRows, describeTableIndexStatsResponse.numUnindexedRows);
    }

    public int hashCode() {
        return Objects.hash(this.distanceType, this.indexType, this.numIndexedRows, this.numUnindexedRows);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DescribeTableIndexStatsResponse {\n");
        sb.append("    distanceType: ").append(this.toIndentedString(this.distanceType)).append("\n");
        sb.append("    indexType: ").append(this.toIndentedString(this.indexType)).append("\n");
        sb.append("    numIndexedRows: ").append(this.toIndentedString(this.numIndexedRows)).append("\n");
        sb.append("    numUnindexedRows: ").append(this.toIndentedString(this.numUnindexedRows)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

