/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.lancedb.lance.namespace.server.springboot.model.JsonArrowSchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DescribeTableResponse {
    private Long version;
    private String location;
    private JsonArrowSchema schema;
    @Valid
    private Map<String, String> properties = new HashMap<String, String>();
    @Valid
    private Map<String, String> storageOptions = new HashMap<String, String>();

    public DescribeTableResponse version(Long version) {
        this.version = version;
        return this;
    }

    @Min(value=0L)
    @Schema(name="version", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public @Min(value=0L) Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public DescribeTableResponse location(String location) {
        this.location = location;
        return this;
    }

    @Schema(name="location", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public DescribeTableResponse schema(JsonArrowSchema schema) {
        this.schema = schema;
        return this;
    }

    @Valid
    @Schema(name="schema", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="schema")
    public JsonArrowSchema getSchema() {
        return this.schema;
    }

    public void setSchema(JsonArrowSchema schema) {
        this.schema = schema;
    }

    public DescribeTableResponse properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public DescribeTableResponse putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Schema(name="properties", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public DescribeTableResponse storageOptions(Map<String, String> storageOptions) {
        this.storageOptions = storageOptions;
        return this;
    }

    public DescribeTableResponse putStorageOptionsItem(String key, String storageOptionsItem) {
        if (this.storageOptions == null) {
            this.storageOptions = new HashMap<String, String>();
        }
        this.storageOptions.put(key, storageOptionsItem);
        return this;
    }

    @Schema(name="storage_options", description="Configuration options to be used to access storage. The available options depend on the type of storage in use. These will be passed directly to Lance to initialize storage access. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="storage_options")
    public Map<String, String> getStorageOptions() {
        return this.storageOptions;
    }

    public void setStorageOptions(Map<String, String> storageOptions) {
        this.storageOptions = storageOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescribeTableResponse describeTableResponse = (DescribeTableResponse)o;
        return Objects.equals(this.version, describeTableResponse.version) && Objects.equals(this.location, describeTableResponse.location) && Objects.equals(this.schema, describeTableResponse.schema) && Objects.equals(this.properties, describeTableResponse.properties) && Objects.equals(this.storageOptions, describeTableResponse.storageOptions);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.location, this.schema, this.properties, this.storageOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DescribeTableResponse {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    storageOptions: ").append(this.toIndentedString(this.storageOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

