/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DropNamespaceRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private ModeEnum mode;
    private BehaviorEnum behavior;

    public DropNamespaceRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public DropNamespaceRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public DropNamespaceRequest mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Schema(name="mode", description="The mode for dropping a namespace, deciding the server behavior when the namespace to drop is not found. - FAIL (default): the server must return 400 indicating the namespace to drop does not exist. - SKIP: the server must return 204 indicating the drop operation has succeeded. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="mode")
    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public DropNamespaceRequest behavior(BehaviorEnum behavior) {
        this.behavior = behavior;
        return this;
    }

    @Schema(name="behavior", description="The behavior for dropping a namespace. - RESTRICT (default): the namespace should not contain any table or child namespace when drop is initiated.     If tables are found, the server should return error and not drop the namespace. - CASCADE: all tables and child namespaces in the namespace are dropped before the namespace is dropped. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="behavior")
    public BehaviorEnum getBehavior() {
        return this.behavior;
    }

    public void setBehavior(BehaviorEnum behavior) {
        this.behavior = behavior;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropNamespaceRequest dropNamespaceRequest = (DropNamespaceRequest)o;
        return Objects.equals(this.id, dropNamespaceRequest.id) && Objects.equals((Object)this.mode, (Object)dropNamespaceRequest.mode) && Objects.equals((Object)this.behavior, (Object)dropNamespaceRequest.behavior);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.mode, this.behavior});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DropNamespaceRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    behavior: ").append(this.toIndentedString((Object)this.behavior)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ModeEnum {
        SKIP("SKIP"),
        FAIL("FAIL");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum BehaviorEnum {
        RESTRICT("RESTRICT"),
        CASCADE("CASCADE");

        private String value;

        private BehaviorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BehaviorEnum fromValue(String value) {
            for (BehaviorEnum b : BehaviorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

