/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DropTableIndexRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private String indexName;

    public DropTableIndexRequest() {
    }

    public DropTableIndexRequest(List<String> id, String indexName) {
        this.id = id;
        this.indexName = indexName;
    }

    public DropTableIndexRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public DropTableIndexRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @NotNull
    @Schema(name="id", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public DropTableIndexRequest indexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    @NotNull
    @Schema(name="index_name", description="Name of the index to drop", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="index_name")
    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropTableIndexRequest dropTableIndexRequest = (DropTableIndexRequest)o;
        return Objects.equals(this.id, dropTableIndexRequest.id) && Objects.equals(this.indexName, dropTableIndexRequest.indexName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.indexName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DropTableIndexRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    indexName: ").append(this.toIndentedString(this.indexName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

