/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.Objects;

@Schema(name="ErrorResponse", description="Common JSON error response model")
public class ErrorResponse {
    private String error;
    private Integer code;
    private String type;
    private String detail;
    private String instance;

    public ErrorResponse error(String error) {
        this.error = error;
        return this;
    }

    @Schema(name="error", example="Incorrect username or password", description="a brief, human-readable message about the error", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="error")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public ErrorResponse code(Integer code) {
        this.code = code;
        return this;
    }

    @Min(value=400L)
    @Max(value=600L)
    @Schema(name="code", example="404", description="HTTP style response code, where 4XX represents client side errors  and 5XX represents server side errors.  For implementations that uses HTTP (e.g. REST namespace), this field can be optional in favor of the HTTP response status code. In case both values exist and do not match, the HTTP response status code should be used. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="code")
    public @Min(value=400L) @Max(value=600L) Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public ErrorResponse type(String type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", example="/errors/incorrect-user-pass", description="An optional type identifier string for the error. This allows the implementation to specify their internal error type, which could be more detailed than the HTTP standard status code. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ErrorResponse detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Schema(name="detail", example="Authentication failed due to incorrect username or password", description="an optional human-readable explanation of the error. This can be used to record information such as stack trace. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="detail")
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public ErrorResponse instance(String instance) {
        this.instance = instance;
        return this;
    }

    @Schema(name="instance", example="/login/log/abc123", description="a string that identifies the specific occurrence of the error. This can be a URI, a request or response ID,  or anything that the implementation can recognize to trace specific occurrence of the error. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="instance")
    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorResponse errorResponse = (ErrorResponse)o;
        return Objects.equals(this.error, errorResponse.error) && Objects.equals(this.code, errorResponse.code) && Objects.equals(this.type, errorResponse.type) && Objects.equals(this.detail, errorResponse.detail) && Objects.equals(this.instance, errorResponse.instance);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.code, this.type, this.detail, this.instance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ErrorResponse {\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    instance: ").append(this.toIndentedString(this.instance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

