/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.lancedb.lance.namespace.server.springboot.model.QueryTableRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExplainTableQueryPlanRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private QueryTableRequest query;
    private Boolean verbose = false;

    public ExplainTableQueryPlanRequest() {
    }

    public ExplainTableQueryPlanRequest(QueryTableRequest query) {
        this.query = query;
    }

    public ExplainTableQueryPlanRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public ExplainTableQueryPlanRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public ExplainTableQueryPlanRequest query(QueryTableRequest query) {
        this.query = query;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="query", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="query")
    public QueryTableRequest getQuery() {
        return this.query;
    }

    public void setQuery(QueryTableRequest query) {
        this.query = query;
    }

    public ExplainTableQueryPlanRequest verbose(Boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Schema(name="verbose", description="Whether to return verbose explanation", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="verbose")
    public Boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExplainTableQueryPlanRequest explainTableQueryPlanRequest = (ExplainTableQueryPlanRequest)o;
        return Objects.equals(this.id, explainTableQueryPlanRequest.id) && Objects.equals(this.query, explainTableQueryPlanRequest.query) && Objects.equals(this.verbose, explainTableQueryPlanRequest.verbose);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.query, this.verbose);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExplainTableQueryPlanRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    verbose: ").append(this.toIndentedString(this.verbose)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

