/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

public class GetTableStatsResponse {
    private Long numRows;
    private Long sizeBytes;
    private Long numFragments;

    public GetTableStatsResponse() {
    }

    public GetTableStatsResponse(Long numRows, Long sizeBytes) {
        this.numRows = numRows;
        this.sizeBytes = sizeBytes;
    }

    public GetTableStatsResponse numRows(Long numRows) {
        this.numRows = numRows;
        return this;
    }

    @NotNull
    @Min(value=0L)
    @Schema(name="num_rows", description="Total number of rows in the table", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="num_rows")
    public @NotNull @Min(value=0L) Long getNumRows() {
        return this.numRows;
    }

    public void setNumRows(Long numRows) {
        this.numRows = numRows;
    }

    public GetTableStatsResponse sizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @NotNull
    @Min(value=0L)
    @Schema(name="size_bytes", description="Total size of the table in bytes", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="size_bytes")
    public @NotNull @Min(value=0L) Long getSizeBytes() {
        return this.sizeBytes;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public GetTableStatsResponse numFragments(Long numFragments) {
        this.numFragments = numFragments;
        return this;
    }

    @Min(value=0L)
    @Schema(name="num_fragments", description="Number of data fragments", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="num_fragments")
    public @Min(value=0L) Long getNumFragments() {
        return this.numFragments;
    }

    public void setNumFragments(Long numFragments) {
        this.numFragments = numFragments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTableStatsResponse getTableStatsResponse = (GetTableStatsResponse)o;
        return Objects.equals(this.numRows, getTableStatsResponse.numRows) && Objects.equals(this.sizeBytes, getTableStatsResponse.sizeBytes) && Objects.equals(this.numFragments, getTableStatsResponse.numFragments);
    }

    public int hashCode() {
        return Objects.hash(this.numRows, this.sizeBytes, this.numFragments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTableStatsResponse {\n");
        sb.append("    numRows: ").append(this.toIndentedString(this.numRows)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("    numFragments: ").append(this.toIndentedString(this.numFragments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

