/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IndexContent {
    private String indexName;
    private String indexUuid;
    @Valid
    private List<String> columns = new ArrayList<String>();
    private String status;

    public IndexContent() {
    }

    public IndexContent(String indexName, String indexUuid, List<String> columns, String status) {
        this.indexName = indexName;
        this.indexUuid = indexUuid;
        this.columns = columns;
        this.status = status;
    }

    public IndexContent indexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    @NotNull
    @Schema(name="index_name", description="Name of the index", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="index_name")
    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public IndexContent indexUuid(String indexUuid) {
        this.indexUuid = indexUuid;
        return this;
    }

    @NotNull
    @Schema(name="index_uuid", description="Unique identifier for the index", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="index_uuid")
    public String getIndexUuid() {
        return this.indexUuid;
    }

    public void setIndexUuid(String indexUuid) {
        this.indexUuid = indexUuid;
    }

    public IndexContent columns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    public IndexContent addColumnsItem(String columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @NotNull
    @Schema(name="columns", description="Columns covered by this index", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="columns")
    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public IndexContent status(String status) {
        this.status = status;
        return this;
    }

    @NotNull
    @Schema(name="status", description="Current status of the index", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexContent indexContent = (IndexContent)o;
        return Objects.equals(this.indexName, indexContent.indexName) && Objects.equals(this.indexUuid, indexContent.indexUuid) && Objects.equals(this.columns, indexContent.columns) && Objects.equals(this.status, indexContent.status);
    }

    public int hashCode() {
        return Objects.hash(this.indexName, this.indexUuid, this.columns, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IndexContent {\n");
        sb.append("    indexName: ").append(this.toIndentedString(this.indexName)).append("\n");
        sb.append("    indexUuid: ").append(this.toIndentedString(this.indexUuid)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

