/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(name="InsertIntoTableRequest", description="Request for inserting records into a table, excluding the Arrow IPC stream. ")
public class InsertIntoTableRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private ModeEnum mode = ModeEnum.APPEND;

    public InsertIntoTableRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public InsertIntoTableRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public InsertIntoTableRequest mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Schema(name="mode", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="mode")
    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertIntoTableRequest insertIntoTableRequest = (InsertIntoTableRequest)o;
        return Objects.equals(this.id, insertIntoTableRequest.id) && Objects.equals((Object)this.mode, (Object)insertIntoTableRequest.mode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.mode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InsertIntoTableRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ModeEnum {
        APPEND("append"),
        OVERWRITE("overwrite");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

