/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.lancedb.lance.namespace.server.springboot.model.JsonArrowField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Schema(name="JsonArrowSchema", description="JSON representation of a Apache Arrow schema. ")
public class JsonArrowSchema {
    @Valid
    private @Valid List<@Valid JsonArrowField> fields = new ArrayList<JsonArrowField>();
    @Valid
    private Map<String, String> metadata = new HashMap<String, String>();

    public JsonArrowSchema() {
    }

    public JsonArrowSchema(List<@Valid JsonArrowField> fields) {
        this.fields = fields;
    }

    public JsonArrowSchema fields(List<@Valid JsonArrowField> fields) {
        this.fields = fields;
        return this;
    }

    public JsonArrowSchema addFieldsItem(JsonArrowField fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<JsonArrowField>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="fields", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="fields")
    public @NotNull @Valid List<@Valid JsonArrowField> getFields() {
        return this.fields;
    }

    public void setFields(List<@Valid JsonArrowField> fields) {
        this.fields = fields;
    }

    public JsonArrowSchema metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonArrowSchema putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Schema(name="metadata", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonArrowSchema jsonArrowSchema = (JsonArrowSchema)o;
        return Objects.equals(this.fields, jsonArrowSchema.fields) && Objects.equals(this.metadata, jsonArrowSchema.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonArrowSchema {\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

