/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class ListNamespacesResponse {
    @Valid
    private Set<String> namespaces = new LinkedHashSet<String>();
    private String pageToken;

    public ListNamespacesResponse() {
    }

    public ListNamespacesResponse(Set<String> namespaces) {
        this.namespaces = namespaces;
    }

    public ListNamespacesResponse namespaces(Set<String> namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public ListNamespacesResponse addNamespacesItem(String namespacesItem) {
        if (this.namespaces == null) {
            this.namespaces = new LinkedHashSet<String>();
        }
        this.namespaces.add(namespacesItem);
        return this;
    }

    @NotNull
    @Schema(name="namespaces", description="The list of names of the child namespaces relative to the parent namespace `id` in the request. ", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="namespaces")
    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setNamespaces(Set<String> namespaces) {
        this.namespaces = namespaces;
    }

    public ListNamespacesResponse pageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    @Schema(name="page_token", description="An opaque token that allows pagination for list operations (e.g. ListNamespaces).  For an initial request of a list operation,  if the implementation cannot return all items in one response, or if there are more items than the page limit specified in the request, the implementation must return a page token in the response, indicating there are more results available.  After the initial request,  the value of the page token from each response must be used as the page token value for the next request.  Caller must interpret either `null`,  missing value or empty string value of the page token from the implementation's response as the end of the listing results. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="page_token")
    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListNamespacesResponse listNamespacesResponse = (ListNamespacesResponse)o;
        return Objects.equals(this.namespaces, listNamespacesResponse.namespaces) && Objects.equals(this.pageToken, listNamespacesResponse.pageToken);
    }

    public int hashCode() {
        return Objects.hash(this.namespaces, this.pageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListNamespacesResponse {\n");
        sb.append("    namespaces: ").append(this.toIndentedString(this.namespaces)).append("\n");
        sb.append("    pageToken: ").append(this.toIndentedString(this.pageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

