/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.lancedb.lance.namespace.server.springboot.model.IndexContent;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ListTableIndicesResponse {
    @Valid
    private @Valid List<@Valid IndexContent> indexes = new ArrayList<IndexContent>();
    private String pageToken;

    public ListTableIndicesResponse() {
    }

    public ListTableIndicesResponse(List<@Valid IndexContent> indexes) {
        this.indexes = indexes;
    }

    public ListTableIndicesResponse indexes(List<@Valid IndexContent> indexes) {
        this.indexes = indexes;
        return this;
    }

    public ListTableIndicesResponse addIndexesItem(IndexContent indexesItem) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<IndexContent>();
        }
        this.indexes.add(indexesItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="indexes", description="List of indexes on the table", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="indexes")
    public @NotNull @Valid List<@Valid IndexContent> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<@Valid IndexContent> indexes) {
        this.indexes = indexes;
    }

    public ListTableIndicesResponse pageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    @Schema(name="page_token", description="An opaque token that allows pagination for list operations (e.g. ListNamespaces).  For an initial request of a list operation,  if the implementation cannot return all items in one response, or if there are more items than the page limit specified in the request, the implementation must return a page token in the response, indicating there are more results available.  After the initial request,  the value of the page token from each response must be used as the page token value for the next request.  Caller must interpret either `null`,  missing value or empty string value of the page token from the implementation's response as the end of the listing results. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="page_token")
    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTableIndicesResponse listTableIndicesResponse = (ListTableIndicesResponse)o;
        return Objects.equals(this.indexes, listTableIndicesResponse.indexes) && Objects.equals(this.pageToken, listTableIndicesResponse.pageToken);
    }

    public int hashCode() {
        return Objects.hash(this.indexes, this.pageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTableIndicesResponse {\n");
        sb.append("    indexes: ").append(this.toIndentedString(this.indexes)).append("\n");
        sb.append("    pageToken: ").append(this.toIndentedString(this.pageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

