/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.lancedb.lance.namespace.server.springboot.model.TagContents;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListTableTagsResponse {
    @Valid
    private Map<String, TagContents> tags = new HashMap<String, TagContents>();

    public ListTableTagsResponse() {
    }

    public ListTableTagsResponse(Map<String, TagContents> tags) {
        this.tags = tags;
    }

    public ListTableTagsResponse tags(Map<String, TagContents> tags) {
        this.tags = tags;
        return this;
    }

    public ListTableTagsResponse putTagsItem(String key, TagContents tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, TagContents>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="tags", description="Map of tag names to their contents", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="tags")
    public Map<String, TagContents> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, TagContents> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTableTagsResponse listTableTagsResponse = (ListTableTagsResponse)o;
        return Objects.equals(this.tags, listTableTagsResponse.tags);
    }

    public int hashCode() {
        return Objects.hash(this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTableTagsResponse {\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

