/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.lancedb.lance.namespace.server.springboot.model.Operator;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

public class MatchQuery {
    private Float boost;
    private String column;
    private Integer fuzziness;
    private Integer maxExpansions;
    private Operator operator;
    private Integer prefixLength;
    private String terms;

    public MatchQuery() {
    }

    public MatchQuery(String column, String terms) {
        this.column = column;
        this.terms = terms;
    }

    public MatchQuery boost(Float boost) {
        this.boost = boost;
        return this;
    }

    @Schema(name="boost", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="boost")
    public Float getBoost() {
        return this.boost;
    }

    public void setBoost(Float boost) {
        this.boost = boost;
    }

    public MatchQuery column(String column) {
        this.column = column;
        return this;
    }

    @NotNull
    @Schema(name="column", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="column")
    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public MatchQuery fuzziness(Integer fuzziness) {
        this.fuzziness = fuzziness;
        return this;
    }

    @Min(value=0L)
    @Schema(name="fuzziness", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="fuzziness")
    public @Min(value=0L) Integer getFuzziness() {
        return this.fuzziness;
    }

    public void setFuzziness(Integer fuzziness) {
        this.fuzziness = fuzziness;
    }

    public MatchQuery maxExpansions(Integer maxExpansions) {
        this.maxExpansions = maxExpansions;
        return this;
    }

    @Min(value=0L)
    @Schema(name="max_expansions", description="The maximum number of terms to expand for fuzzy matching. Default to 50.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="max_expansions")
    public @Min(value=0L) Integer getMaxExpansions() {
        return this.maxExpansions;
    }

    public void setMaxExpansions(Integer maxExpansions) {
        this.maxExpansions = maxExpansions;
    }

    public MatchQuery operator(Operator operator) {
        this.operator = operator;
        return this;
    }

    @Valid
    @Schema(name="operator", description="The operator to use for combining terms. This can be either `And` or `Or`, it's 'Or' by default. - `And`: All terms must match. - `Or`: At least one term must match.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="operator")
    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public MatchQuery prefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    @Min(value=0L)
    @Schema(name="prefix_length", description="The number of beginning characters being unchanged for fuzzy matching. Default to 0.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="prefix_length")
    public @Min(value=0L) Integer getPrefixLength() {
        return this.prefixLength;
    }

    public void setPrefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
    }

    public MatchQuery terms(String terms) {
        this.terms = terms;
        return this;
    }

    @NotNull
    @Schema(name="terms", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="terms")
    public String getTerms() {
        return this.terms;
    }

    public void setTerms(String terms) {
        this.terms = terms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchQuery matchQuery = (MatchQuery)o;
        return Objects.equals(this.boost, matchQuery.boost) && Objects.equals(this.column, matchQuery.column) && Objects.equals(this.fuzziness, matchQuery.fuzziness) && Objects.equals(this.maxExpansions, matchQuery.maxExpansions) && Objects.equals((Object)this.operator, (Object)matchQuery.operator) && Objects.equals(this.prefixLength, matchQuery.prefixLength) && Objects.equals(this.terms, matchQuery.terms);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.boost, this.column, this.fuzziness, this.maxExpansions, this.operator, this.prefixLength, this.terms});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MatchQuery {\n");
        sb.append("    boost: ").append(this.toIndentedString(this.boost)).append("\n");
        sb.append("    column: ").append(this.toIndentedString(this.column)).append("\n");
        sb.append("    fuzziness: ").append(this.toIndentedString(this.fuzziness)).append("\n");
        sb.append("    maxExpansions: ").append(this.toIndentedString(this.maxExpansions)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    prefixLength: ").append(this.toIndentedString(this.prefixLength)).append("\n");
        sb.append("    terms: ").append(this.toIndentedString(this.terms)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

