/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(name="MergeInsertIntoTableRequest", description="Request for merging or inserting records into a table, excluding the Arrow IPC stream. ")
public class MergeInsertIntoTableRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private String on;
    private Boolean whenMatchedUpdateAll = false;
    private String whenMatchedUpdateAllFilt;
    private Boolean whenNotMatchedInsertAll = false;
    private Boolean whenNotMatchedBySourceDelete = false;
    private String whenNotMatchedBySourceDeleteFilt;

    public MergeInsertIntoTableRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public MergeInsertIntoTableRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public MergeInsertIntoTableRequest on(String on) {
        this.on = on;
        return this;
    }

    @Schema(name="on", description="Column name to use for matching rows (required)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="on")
    public String getOn() {
        return this.on;
    }

    public void setOn(String on) {
        this.on = on;
    }

    public MergeInsertIntoTableRequest whenMatchedUpdateAll(Boolean whenMatchedUpdateAll) {
        this.whenMatchedUpdateAll = whenMatchedUpdateAll;
        return this;
    }

    @Schema(name="when_matched_update_all", description="Update all columns when rows match", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="when_matched_update_all")
    public Boolean getWhenMatchedUpdateAll() {
        return this.whenMatchedUpdateAll;
    }

    public void setWhenMatchedUpdateAll(Boolean whenMatchedUpdateAll) {
        this.whenMatchedUpdateAll = whenMatchedUpdateAll;
    }

    public MergeInsertIntoTableRequest whenMatchedUpdateAllFilt(String whenMatchedUpdateAllFilt) {
        this.whenMatchedUpdateAllFilt = whenMatchedUpdateAllFilt;
        return this;
    }

    @Schema(name="when_matched_update_all_filt", description="The row is updated (similar to UpdateAll) only for rows where the SQL expression evaluates to true", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="when_matched_update_all_filt")
    public String getWhenMatchedUpdateAllFilt() {
        return this.whenMatchedUpdateAllFilt;
    }

    public void setWhenMatchedUpdateAllFilt(String whenMatchedUpdateAllFilt) {
        this.whenMatchedUpdateAllFilt = whenMatchedUpdateAllFilt;
    }

    public MergeInsertIntoTableRequest whenNotMatchedInsertAll(Boolean whenNotMatchedInsertAll) {
        this.whenNotMatchedInsertAll = whenNotMatchedInsertAll;
        return this;
    }

    @Schema(name="when_not_matched_insert_all", description="Insert all columns when rows don't match", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="when_not_matched_insert_all")
    public Boolean getWhenNotMatchedInsertAll() {
        return this.whenNotMatchedInsertAll;
    }

    public void setWhenNotMatchedInsertAll(Boolean whenNotMatchedInsertAll) {
        this.whenNotMatchedInsertAll = whenNotMatchedInsertAll;
    }

    public MergeInsertIntoTableRequest whenNotMatchedBySourceDelete(Boolean whenNotMatchedBySourceDelete) {
        this.whenNotMatchedBySourceDelete = whenNotMatchedBySourceDelete;
        return this;
    }

    @Schema(name="when_not_matched_by_source_delete", description="Delete all rows from target table that don't match a row in the source table", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="when_not_matched_by_source_delete")
    public Boolean getWhenNotMatchedBySourceDelete() {
        return this.whenNotMatchedBySourceDelete;
    }

    public void setWhenNotMatchedBySourceDelete(Boolean whenNotMatchedBySourceDelete) {
        this.whenNotMatchedBySourceDelete = whenNotMatchedBySourceDelete;
    }

    public MergeInsertIntoTableRequest whenNotMatchedBySourceDeleteFilt(String whenNotMatchedBySourceDeleteFilt) {
        this.whenNotMatchedBySourceDeleteFilt = whenNotMatchedBySourceDeleteFilt;
        return this;
    }

    @Schema(name="when_not_matched_by_source_delete_filt", description="Delete rows from the target table if there is no match AND the SQL expression evaluates to true", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="when_not_matched_by_source_delete_filt")
    public String getWhenNotMatchedBySourceDeleteFilt() {
        return this.whenNotMatchedBySourceDeleteFilt;
    }

    public void setWhenNotMatchedBySourceDeleteFilt(String whenNotMatchedBySourceDeleteFilt) {
        this.whenNotMatchedBySourceDeleteFilt = whenNotMatchedBySourceDeleteFilt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeInsertIntoTableRequest mergeInsertIntoTableRequest = (MergeInsertIntoTableRequest)o;
        return Objects.equals(this.id, mergeInsertIntoTableRequest.id) && Objects.equals(this.on, mergeInsertIntoTableRequest.on) && Objects.equals(this.whenMatchedUpdateAll, mergeInsertIntoTableRequest.whenMatchedUpdateAll) && Objects.equals(this.whenMatchedUpdateAllFilt, mergeInsertIntoTableRequest.whenMatchedUpdateAllFilt) && Objects.equals(this.whenNotMatchedInsertAll, mergeInsertIntoTableRequest.whenNotMatchedInsertAll) && Objects.equals(this.whenNotMatchedBySourceDelete, mergeInsertIntoTableRequest.whenNotMatchedBySourceDelete) && Objects.equals(this.whenNotMatchedBySourceDeleteFilt, mergeInsertIntoTableRequest.whenNotMatchedBySourceDeleteFilt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.on, this.whenMatchedUpdateAll, this.whenMatchedUpdateAllFilt, this.whenNotMatchedInsertAll, this.whenNotMatchedBySourceDelete, this.whenNotMatchedBySourceDeleteFilt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MergeInsertIntoTableRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    on: ").append(this.toIndentedString(this.on)).append("\n");
        sb.append("    whenMatchedUpdateAll: ").append(this.toIndentedString(this.whenMatchedUpdateAll)).append("\n");
        sb.append("    whenMatchedUpdateAllFilt: ").append(this.toIndentedString(this.whenMatchedUpdateAllFilt)).append("\n");
        sb.append("    whenNotMatchedInsertAll: ").append(this.toIndentedString(this.whenNotMatchedInsertAll)).append("\n");
        sb.append("    whenNotMatchedBySourceDelete: ").append(this.toIndentedString(this.whenNotMatchedBySourceDelete)).append("\n");
        sb.append("    whenNotMatchedBySourceDeleteFilt: ").append(this.toIndentedString(this.whenNotMatchedBySourceDeleteFilt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

