/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import java.util.Objects;

@Schema(name="MergeInsertIntoTableResponse", description="Response from merge insert operation")
public class MergeInsertIntoTableResponse {
    private Long numUpdatedRows;
    private Long numInsertedRows;
    private Long numDeletedRows;
    private Long version;

    public MergeInsertIntoTableResponse numUpdatedRows(Long numUpdatedRows) {
        this.numUpdatedRows = numUpdatedRows;
        return this;
    }

    @Min(value=0L)
    @Schema(name="num_updated_rows", description="Number of rows updated", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="num_updated_rows")
    public @Min(value=0L) Long getNumUpdatedRows() {
        return this.numUpdatedRows;
    }

    public void setNumUpdatedRows(Long numUpdatedRows) {
        this.numUpdatedRows = numUpdatedRows;
    }

    public MergeInsertIntoTableResponse numInsertedRows(Long numInsertedRows) {
        this.numInsertedRows = numInsertedRows;
        return this;
    }

    @Min(value=0L)
    @Schema(name="num_inserted_rows", description="Number of rows inserted", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="num_inserted_rows")
    public @Min(value=0L) Long getNumInsertedRows() {
        return this.numInsertedRows;
    }

    public void setNumInsertedRows(Long numInsertedRows) {
        this.numInsertedRows = numInsertedRows;
    }

    public MergeInsertIntoTableResponse numDeletedRows(Long numDeletedRows) {
        this.numDeletedRows = numDeletedRows;
        return this;
    }

    @Min(value=0L)
    @Schema(name="num_deleted_rows", description="Number of rows deleted (typically 0 for merge insert)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="num_deleted_rows")
    public @Min(value=0L) Long getNumDeletedRows() {
        return this.numDeletedRows;
    }

    public void setNumDeletedRows(Long numDeletedRows) {
        this.numDeletedRows = numDeletedRows;
    }

    public MergeInsertIntoTableResponse version(Long version) {
        this.version = version;
        return this;
    }

    @Min(value=0L)
    @Schema(name="version", description="The commit version associated with the operation", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public @Min(value=0L) Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeInsertIntoTableResponse mergeInsertIntoTableResponse = (MergeInsertIntoTableResponse)o;
        return Objects.equals(this.numUpdatedRows, mergeInsertIntoTableResponse.numUpdatedRows) && Objects.equals(this.numInsertedRows, mergeInsertIntoTableResponse.numInsertedRows) && Objects.equals(this.numDeletedRows, mergeInsertIntoTableResponse.numDeletedRows) && Objects.equals(this.version, mergeInsertIntoTableResponse.version);
    }

    public int hashCode() {
        return Objects.hash(this.numUpdatedRows, this.numInsertedRows, this.numDeletedRows, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MergeInsertIntoTableResponse {\n");
        sb.append("    numUpdatedRows: ").append(this.toIndentedString(this.numUpdatedRows)).append("\n");
        sb.append("    numInsertedRows: ").append(this.toIndentedString(this.numInsertedRows)).append("\n");
        sb.append("    numDeletedRows: ").append(this.toIndentedString(this.numDeletedRows)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

