/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

public class NewColumnTransform {
    private String name;
    private String expression;

    public NewColumnTransform() {
    }

    public NewColumnTransform(String name, String expression) {
        this.name = name;
        this.expression = expression;
    }

    public NewColumnTransform name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", description="Name of the new column", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NewColumnTransform expression(String expression) {
        this.expression = expression;
        return this;
    }

    @NotNull
    @Schema(name="expression", description="SQL expression to compute the column value", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="expression")
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewColumnTransform newColumnTransform = (NewColumnTransform)o;
        return Objects.equals(this.name, newColumnTransform.name) && Objects.equals(this.expression, newColumnTransform.expression);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.expression);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NewColumnTransform {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

