/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(name="QueryTableRequest_vector", description="Query vector(s) for similarity search. Provide either single_vector or multi_vector, not both.")
@JsonTypeName(value="QueryTableRequest_vector")
public class QueryTableRequestVector {
    @Valid
    private List<Float> singleVector = new ArrayList<Float>();
    @Valid
    private List<List<Float>> multiVector = new ArrayList<List<Float>>();

    public QueryTableRequestVector singleVector(List<Float> singleVector) {
        this.singleVector = singleVector;
        return this;
    }

    public QueryTableRequestVector addSingleVectorItem(Float singleVectorItem) {
        if (this.singleVector == null) {
            this.singleVector = new ArrayList<Float>();
        }
        this.singleVector.add(singleVectorItem);
        return this;
    }

    @Schema(name="single_vector", description="Single query vector", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="single_vector")
    public List<Float> getSingleVector() {
        return this.singleVector;
    }

    public void setSingleVector(List<Float> singleVector) {
        this.singleVector = singleVector;
    }

    public QueryTableRequestVector multiVector(List<List<Float>> multiVector) {
        this.multiVector = multiVector;
        return this;
    }

    public QueryTableRequestVector addMultiVectorItem(List<Float> multiVectorItem) {
        if (this.multiVector == null) {
            this.multiVector = new ArrayList<List<Float>>();
        }
        this.multiVector.add(multiVectorItem);
        return this;
    }

    @Valid
    @Schema(name="multi_vector", description="Multiple query vectors for batch search", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="multi_vector")
    public List<List<Float>> getMultiVector() {
        return this.multiVector;
    }

    public void setMultiVector(List<List<Float>> multiVector) {
        this.multiVector = multiVector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryTableRequestVector queryTableRequestVector = (QueryTableRequestVector)o;
        return Objects.equals(this.singleVector, queryTableRequestVector.singleVector) && Objects.equals(this.multiVector, queryTableRequestVector.multiVector);
    }

    public int hashCode() {
        return Objects.hash(this.singleVector, this.multiVector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryTableRequestVector {\n");
        sb.append("    singleVector: ").append(this.toIndentedString(this.singleVector)).append("\n");
        sb.append("    multiVector: ").append(this.toIndentedString(this.multiVector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

