/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

public class TableVersion {
    private Long version;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime timestamp;

    public TableVersion() {
    }

    public TableVersion(Long version, OffsetDateTime timestamp) {
        this.version = version;
        this.timestamp = timestamp;
    }

    public TableVersion version(Long version) {
        this.version = version;
        return this;
    }

    @NotNull
    @Min(value=0L)
    @Schema(name="version", description="Version number", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="version")
    public @NotNull @Min(value=0L) Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public TableVersion timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="timestamp", description="Timestamp when the version was created", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="timestamp")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableVersion tableVersion = (TableVersion)o;
        return Objects.equals(this.version, tableVersion.version) && Objects.equals(this.timestamp, tableVersion.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableVersion {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

