/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(name="UpdateTableRequest", description="Each update consists of a column name and an SQL expression that will be evaluated against the current row's value. Optionally, a predicate can be provided to filter which rows to update. ")
public class UpdateTableRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private String predicate;
    @Valid
    private List<List<String>> updates = new ArrayList<List<String>>();

    public UpdateTableRequest() {
    }

    public UpdateTableRequest(List<List<String>> updates) {
        this.updates = updates;
    }

    public UpdateTableRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public UpdateTableRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public UpdateTableRequest predicate(String predicate) {
        this.predicate = predicate;
        return this;
    }

    @Schema(name="predicate", description="Optional SQL predicate to filter rows for update", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="predicate")
    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    public UpdateTableRequest updates(List<List<String>> updates) {
        this.updates = updates;
        return this;
    }

    public UpdateTableRequest addUpdatesItem(List<String> updatesItem) {
        if (this.updates == null) {
            this.updates = new ArrayList<List<String>>();
        }
        this.updates.add(updatesItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="updates", description="List of column updates as [column_name, expression] pairs", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="updates")
    public List<List<String>> getUpdates() {
        return this.updates;
    }

    public void setUpdates(List<List<String>> updates) {
        this.updates = updates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateTableRequest updateTableRequest = (UpdateTableRequest)o;
        return Objects.equals(this.id, updateTableRequest.id) && Objects.equals(this.predicate, updateTableRequest.predicate) && Objects.equals(this.updates, updateTableRequest.updates);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.predicate, this.updates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateTableRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    predicate: ").append(this.toIndentedString(this.predicate)).append("\n");
        sb.append("    updates: ").append(this.toIndentedString(this.updates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

