/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UpdateTableTagRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private String tag;
    private Long version;

    public UpdateTableTagRequest() {
    }

    public UpdateTableTagRequest(String tag, Long version) {
        this.tag = tag;
        this.version = version;
    }

    public UpdateTableTagRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public UpdateTableTagRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public UpdateTableTagRequest tag(String tag) {
        this.tag = tag;
        return this;
    }

    @NotNull
    @Schema(name="tag", description="Name of the tag to update", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="tag")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public UpdateTableTagRequest version(Long version) {
        this.version = version;
        return this;
    }

    @NotNull
    @Min(value=0L)
    @Schema(name="version", description="New version number for the tag to point to", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="version")
    public @NotNull @Min(value=0L) Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateTableTagRequest updateTableTagRequest = (UpdateTableTagRequest)o;
        return Objects.equals(this.id, updateTableTagRequest.id) && Objects.equals(this.tag, updateTableTagRequest.tag) && Objects.equals(this.version, updateTableTagRequest.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tag, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateTableTagRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

