/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.lancedb.lance.Dataset;
import com.lancedb.lance.Fragment;
import com.lancedb.lance.ReadOptions;
import com.lancedb.lance.ipc.LanceScanner;
import com.lancedb.lance.ipc.ScanOptions;
import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.SparkOptions;
import com.lancedb.lance.spark.internal.LanceDatasetAdapter;
import com.lancedb.lance.spark.read.LanceInputPartition;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class LanceFragmentScanner
implements AutoCloseable {
    private static LoadingCache<CacheKey, Map<Integer, Fragment>> LOADING_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<CacheKey, Map<Integer, Fragment>>(){

        public Map<Integer, Fragment> load(CacheKey key) throws Exception {
            BufferAllocator allocator = LanceDatasetAdapter.allocator;
            LanceConfig config = key.getConfig();
            ReadOptions options = SparkOptions.genReadOptionFromConfig(config);
            Dataset dataset = Dataset.open((BufferAllocator)allocator, (String)config.getDatasetUri(), (ReadOptions)options);
            return dataset.getFragments().stream().collect(Collectors.toMap(Fragment::getId, f -> f));
        }
    });
    private final LanceScanner scanner;

    private LanceFragmentScanner(LanceScanner scanner) {
        this.scanner = scanner;
    }

    public static LanceFragmentScanner create(int fragmentId, LanceInputPartition inputPartition) {
        try {
            LanceConfig config = inputPartition.getConfig();
            CacheKey key = new CacheKey(config, inputPartition.getScanId());
            Map cachedFragments = (Map)LOADING_CACHE.get((Object)key);
            Fragment fragment = (Fragment)cachedFragments.get(fragmentId);
            ScanOptions.Builder scanOptions = new ScanOptions.Builder();
            scanOptions.columns(LanceFragmentScanner.getColumnNames(inputPartition.getSchema()));
            if (inputPartition.getWhereCondition().isPresent()) {
                scanOptions.filter(inputPartition.getWhereCondition().get());
            }
            scanOptions.batchSize((long)SparkOptions.getBatchSize(config));
            scanOptions.withRowId(LanceFragmentScanner.getWithRowId(inputPartition.getSchema()));
            scanOptions.withRowAddress(LanceFragmentScanner.getWithRowAddress(inputPartition.getSchema()));
            if (inputPartition.getLimit().isPresent()) {
                scanOptions.limit((long)inputPartition.getLimit().get().intValue());
            }
            if (inputPartition.getOffset().isPresent()) {
                scanOptions.offset((long)inputPartition.getOffset().get().intValue());
            }
            if (inputPartition.getTopNSortOrders().isPresent()) {
                scanOptions.setColumnOrderings(inputPartition.getTopNSortOrders().get());
            }
            return new LanceFragmentScanner(fragment.newScan(scanOptions.build()));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public ArrowReader getArrowReader() {
        return this.scanner.scanBatches();
    }

    @Override
    public void close() throws IOException {
        if (this.scanner != null) {
            try {
                this.scanner.close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private static List<String> getColumnNames(StructType schema) {
        return Arrays.stream(schema.fields()).map(StructField::name).filter(name -> !name.equals("_rowid") && !name.equals("_rowaddr")).collect(Collectors.toList());
    }

    private static boolean getWithRowId(StructType schema) {
        return Arrays.stream(schema.fields()).map(StructField::name).anyMatch(name -> name.equals("_rowid"));
    }

    private static boolean getWithRowAddress(StructType schema) {
        return Arrays.stream(schema.fields()).map(StructField::name).anyMatch(name -> name.equals("_rowaddr"));
    }

    private static class CacheKey {
        private final LanceConfig config;
        private final String scanId;

        CacheKey(LanceConfig config, String scanId) {
            this.config = config;
            this.scanId = scanId;
        }

        public LanceConfig getConfig() {
            return this.config;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.config, cacheKey.config) && Objects.equals(this.scanId, cacheKey.scanId);
        }

        public int hashCode() {
            return Objects.hash(this.config, this.scanId);
        }
    }
}

