/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.read;

import com.lancedb.lance.ipc.ColumnOrdering;
import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.SparkOptions;
import com.lancedb.lance.spark.internal.LanceDatasetAdapter;
import com.lancedb.lance.spark.read.FilterPushDown;
import com.lancedb.lance.spark.read.LanceScan;
import com.lancedb.lance.spark.utils.Optional;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.NullOrdering;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownLimit;
import org.apache.spark.sql.connector.read.SupportsPushDownOffset;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.connector.read.SupportsPushDownTopN;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;

public class LanceScanBuilder
implements SupportsPushDownRequiredColumns,
SupportsPushDownFilters,
SupportsPushDownLimit,
SupportsPushDownOffset,
SupportsPushDownTopN {
    private final LanceConfig config;
    private StructType schema;
    private Filter[] pushedFilters = new Filter[0];
    private Optional<Integer> limit = Optional.empty();
    private Optional<Integer> offset = Optional.empty();
    private Optional<List<ColumnOrdering>> topNSortOrders = Optional.empty();

    public LanceScanBuilder(StructType schema, LanceConfig config) {
        this.schema = schema;
        this.config = config;
    }

    public Scan build() {
        Optional<String> whereCondition = FilterPushDown.compileFiltersToSqlWhereClause(this.pushedFilters);
        return new LanceScan(this.schema, this.config, whereCondition, this.limit, this.offset, this.topNSortOrders);
    }

    public void pruneColumns(StructType requiredSchema) {
        if (!requiredSchema.isEmpty()) {
            this.schema = requiredSchema;
        }
    }

    public Filter[] pushFilters(Filter[] filters) {
        if (!this.config.isPushDownFilters()) {
            return filters;
        }
        Filter[][] processFilters = FilterPushDown.processFilters(filters);
        this.pushedFilters = processFilters[0];
        return processFilters[1];
    }

    public Filter[] pushedFilters() {
        return this.pushedFilters;
    }

    public boolean pushLimit(int limit) {
        this.limit = Optional.of(limit);
        return true;
    }

    public boolean pushOffset(int offset) {
        if (LanceDatasetAdapter.getFragmentIds(this.config).size() == 1) {
            this.offset = Optional.of(offset);
            return true;
        }
        return false;
    }

    public boolean isPartiallyPushed() {
        return true;
    }

    public boolean pushTopN(SortOrder[] orders, int limit) {
        if (!SparkOptions.enableTopNPushDown(this.config)) {
            return false;
        }
        this.limit = Optional.of(limit);
        ArrayList<ColumnOrdering> topNSortOrders = new ArrayList<ColumnOrdering>();
        for (SortOrder sortOrder : orders) {
            ColumnOrdering.Builder builder = new ColumnOrdering.Builder();
            builder.setNullFirst(sortOrder.nullOrdering() == NullOrdering.NULLS_FIRST);
            builder.setAscending(sortOrder.direction() == SortDirection.ASCENDING);
            if (!(sortOrder.expression() instanceof FieldReference)) {
                return false;
            }
            FieldReference reference = (FieldReference)sortOrder.expression();
            builder.setColumnName(reference.fieldNames()[0]);
            topNSortOrders.add(builder.build());
        }
        this.topNSortOrders = Optional.of(topNSortOrders);
        return true;
    }
}

