/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.write;

import com.lancedb.lance.FragmentMetadata;
import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.SparkOptions;
import com.lancedb.lance.spark.internal.LanceDatasetAdapter;
import com.lancedb.lance.spark.write.LanceDataWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;

public class LanceBatchWrite
implements BatchWrite {
    private final StructType schema;
    private final LanceConfig config;
    private final boolean overwrite;

    public LanceBatchWrite(StructType schema, LanceConfig config, boolean overwrite) {
        this.schema = schema;
        this.config = config;
        this.overwrite = overwrite;
    }

    public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
        return new LanceDataWriter.WriterFactory(this.schema, this.config);
    }

    public boolean useCommitCoordinator() {
        return false;
    }

    public void commit(WriterCommitMessage[] messages) {
        List<FragmentMetadata> fragments = Arrays.stream(messages).map(m -> (TaskCommit)m).map(TaskCommit::getFragments).flatMap(Collection::stream).collect(Collectors.toList());
        if (this.overwrite || SparkOptions.overwrite(this.config)) {
            LanceDatasetAdapter.overwriteFragments(this.config, fragments, this.schema);
        } else {
            LanceDatasetAdapter.appendFragments(this.config, fragments);
        }
    }

    public void abort(WriterCommitMessage[] messages) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("LanceBatchWrite(datasetUri=%s)", this.config.getDatasetUri());
    }

    public static class TaskCommit
    implements WriterCommitMessage {
        private final List<FragmentMetadata> fragments;

        TaskCommit(List<FragmentMetadata> fragments) {
            this.fragments = fragments;
        }

        List<FragmentMetadata> getFragments() {
            return this.fragments;
        }
    }
}

