/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import com.lancedb.lance.WriteParams;
import com.lancedb.lance.namespace.LanceNamespace;
import com.lancedb.lance.namespace.LanceNamespaceException;
import com.lancedb.lance.namespace.LanceNamespaces;
import com.lancedb.lance.namespace.ListTablesIterable;
import com.lancedb.lance.namespace.model.CreateEmptyTableRequest;
import com.lancedb.lance.namespace.model.CreateEmptyTableResponse;
import com.lancedb.lance.namespace.model.CreateNamespaceRequest;
import com.lancedb.lance.namespace.model.DescribeNamespaceRequest;
import com.lancedb.lance.namespace.model.DescribeNamespaceResponse;
import com.lancedb.lance.namespace.model.DescribeTableRequest;
import com.lancedb.lance.namespace.model.DescribeTableResponse;
import com.lancedb.lance.namespace.model.DropNamespaceRequest;
import com.lancedb.lance.namespace.model.DropTableRequest;
import com.lancedb.lance.namespace.model.JsonArrowSchema;
import com.lancedb.lance.namespace.model.ListNamespacesRequest;
import com.lancedb.lance.namespace.model.ListNamespacesResponse;
import com.lancedb.lance.namespace.model.ListTablesRequest;
import com.lancedb.lance.namespace.model.NamespaceExistsRequest;
import com.lancedb.lance.namespace.model.TableExistsRequest;
import com.lancedb.lance.namespace.util.PropertyUtil;
import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.LanceDataset;
import com.lancedb.lance.spark.internal.LanceDatasetAdapter;
import com.lancedb.lance.spark.utils.Optional;
import com.lancedb.lance.spark.utils.SchemaConverter;
import com.lancedb.lance.spark.utils.SparkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLanceNamespaceSparkCatalog
implements TableCatalog,
SupportsNamespaces {
    private static final Logger logger = LoggerFactory.getLogger(BaseLanceNamespaceSparkCatalog.class);
    private static final String CONFIG_IMPL = "impl";
    private static final String CONFIG_EXTRA_LEVEL = "extra_level";
    private static final String CREATE_TABLE_PROPERTY_LOCATION = "location";
    private static final String CONFIG_PARENT = "parent";
    private static final String CONFIG_PARENT_DELIMITER = "parent_delimiter";
    private static final String CONFIG_PARENT_DELIMITER_DEFAULT = ".";
    private LanceNamespace namespace;
    private String name;
    private Optional<String> extraLevel;
    private Optional<List<String>> parentPrefix;

    public void initialize(String name, CaseInsensitiveStringMap options) {
        this.name = name;
        if (!options.containsKey((Object)CONFIG_IMPL)) {
            throw new IllegalArgumentException("Missing required configuration: impl");
        }
        String impl = PropertyUtil.propertyAsString((Map)options, (String)CONFIG_IMPL);
        if (options.containsKey((Object)CONFIG_PARENT)) {
            String parent = PropertyUtil.propertyAsString((Map)options, (String)CONFIG_PARENT);
            String delimiter = PropertyUtil.propertyAsString((Map)options, (String)CONFIG_PARENT_DELIMITER, (String)CONFIG_PARENT_DELIMITER_DEFAULT);
            List<String> parentParts = Arrays.asList(parent.split(Pattern.quote(delimiter)));
            this.parentPrefix = Optional.of(parentParts);
        } else {
            this.parentPrefix = Optional.empty();
        }
        HashMap namespaceOptions = new HashMap(options);
        Configuration hadoopConf = SparkUtil.hadoopConfCatalogOverrides(SparkSession.active(), name);
        this.namespace = LanceNamespaces.connect((String)impl, namespaceOptions, (Object)hadoopConf, (BufferAllocator)LanceDatasetAdapter.allocator);
        this.extraLevel = options.containsKey((Object)CONFIG_EXTRA_LEVEL) ? Optional.of(PropertyUtil.propertyAsString((Map)options, (String)CONFIG_EXTRA_LEVEL)) : ("dir".equals(impl) ? Optional.of("default") : ("rest".equals(impl) ? this.determineExtraLevelForRest() : Optional.empty()));
    }

    public String name() {
        return this.name;
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) throws NoSuchNamespaceException {
        throw new UnsupportedOperationException("Namespace alteration is not supported");
    }

    public String[][] listNamespaces() throws NoSuchNamespaceException {
        ListNamespacesRequest request = new ListNamespacesRequest();
        if (this.parentPrefix.isPresent()) {
            request.setId(this.parentPrefix.get());
        }
        try {
            ListNamespacesResponse response = this.namespace.listNamespaces(request);
            ArrayList<String[]> result = new ArrayList<String[]>();
            for (String ns : response.getNamespaces()) {
                String[] nsArray = new String[]{ns};
                if (this.extraLevel.isPresent()) {
                    String[] withExtra = new String[]{this.extraLevel.get(), ns};
                    nsArray = withExtra;
                }
                result.add(nsArray);
            }
            return (String[][])result.toArray((T[])new String[0][]);
        }
        catch (Exception e) {
            throw new NoSuchNamespaceException(new String[0]);
        }
    }

    public String[][] listNamespaces(String[] parent) throws NoSuchNamespaceException {
        String[] actualParent = this.removeExtraLevelsFromNamespace(parent);
        actualParent = this.addParentPrefix(actualParent);
        ListNamespacesRequest request = new ListNamespacesRequest();
        request.setId(Arrays.asList(actualParent));
        try {
            ListNamespacesResponse response = this.namespace.listNamespaces(request);
            ArrayList<String[]> result = new ArrayList<String[]>();
            for (String ns : response.getNamespaces()) {
                String[] nsArray = new String[parent.length + 1];
                System.arraycopy(parent, 0, nsArray, 0, parent.length);
                nsArray[parent.length] = ns;
                result.add(nsArray);
            }
            return (String[][])result.toArray((T[])new String[0][]);
        }
        catch (Exception e) {
            throw new NoSuchNamespaceException(parent);
        }
    }

    public boolean namespaceExists(String[] namespace) {
        if (this.extraLevel.isPresent() && namespace.length == 1 && this.extraLevel.get().equals(namespace[0])) {
            return true;
        }
        String[] actualNamespace = this.removeExtraLevelsFromNamespace(namespace);
        actualNamespace = this.addParentPrefix(actualNamespace);
        NamespaceExistsRequest request = new NamespaceExistsRequest();
        request.setId(Arrays.asList(actualNamespace));
        try {
            this.namespace.namespaceExists(request);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        String[] actualNamespace = this.removeExtraLevelsFromNamespace(namespace);
        actualNamespace = this.addParentPrefix(actualNamespace);
        DescribeNamespaceRequest request = new DescribeNamespaceRequest();
        request.setId(Arrays.asList(actualNamespace));
        try {
            DescribeNamespaceResponse response = this.namespace.describeNamespace(request);
            Map<String, String> properties = response.getProperties();
            return properties != null ? properties : Collections.emptyMap();
        }
        catch (Exception e) {
            throw new NoSuchNamespaceException(namespace);
        }
    }

    public void createNamespace(String[] namespace, Map<String, String> properties) throws NamespaceAlreadyExistsException {
        String[] actualNamespace = this.removeExtraLevelsFromNamespace(namespace);
        actualNamespace = this.addParentPrefix(actualNamespace);
        CreateNamespaceRequest request = new CreateNamespaceRequest();
        request.setId(Arrays.asList(actualNamespace));
        if (properties != null && !properties.isEmpty()) {
            request.setProperties(properties);
        }
        try {
            this.namespace.createNamespace(request);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("already exists")) {
                throw new NamespaceAlreadyExistsException(namespace);
            }
            throw new RuntimeException("Failed to create namespace", e);
        }
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) throws NoSuchNamespaceException {
        String[] actualNamespace = this.removeExtraLevelsFromNamespace(namespace);
        actualNamespace = this.addParentPrefix(actualNamespace);
        DropNamespaceRequest request = new DropNamespaceRequest();
        request.setId(Arrays.asList(actualNamespace));
        if (cascade) {
            request.setBehavior(DropNamespaceRequest.BehaviorEnum.CASCADE);
        } else {
            request.setBehavior(DropNamespaceRequest.BehaviorEnum.RESTRICT);
        }
        this.namespace.dropNamespace(request);
        return true;
    }

    public Identifier[] listTables(String[] namespace) throws NoSuchNamespaceException {
        String[] actualNamespace = this.removeExtraLevelsFromNamespace(namespace);
        actualNamespace = this.addParentPrefix(actualNamespace);
        ListTablesRequest request = new ListTablesRequest();
        request.setId(Arrays.stream(actualNamespace).collect(Collectors.toList()));
        ListTablesIterable tables = new ListTablesIterable(this.namespace, request);
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (String table : tables) {
            identifiers.add(Identifier.of((String[])namespace, (String)table));
        }
        return identifiers.toArray(new Identifier[0]);
    }

    public boolean tableExists(Identifier ident) {
        Identifier actualIdent = this.transformIdentifierForApi(ident);
        TableExistsRequest request = new TableExistsRequest();
        for (String part : actualIdent.namespace()) {
            request.addIdItem(part);
        }
        request.addIdItem(actualIdent.name());
        try {
            this.namespace.tableExists(request);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Table loadTable(Identifier ident) throws NoSuchTableException {
        LanceConfig config;
        Optional<StructType> schema;
        DescribeTableResponse response;
        Identifier actualIdent = this.transformIdentifierForApi(ident);
        DescribeTableRequest request = new DescribeTableRequest();
        for (String part : actualIdent.namespace()) {
            request.addIdItem(part);
        }
        request.addIdItem(actualIdent.name());
        try {
            response = this.namespace.describeTable(request);
        }
        catch (LanceNamespaceException e) {
            if (e.getCode() == 404) {
                throw new NoSuchTableException(ident);
            }
            throw e;
        }
        HashMap<String, String> storageOptions = response.getStorageOptions();
        if (storageOptions == null) {
            storageOptions = new HashMap<String, String>();
        }
        if (!(schema = LanceDatasetAdapter.getSchema(config = LanceConfig.from(storageOptions, response.getLocation()))).isPresent()) {
            throw new NoSuchTableException(ident);
        }
        return this.createDataset(config, schema.get());
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        Identifier tableId = this.transformIdentifierForApi(ident);
        CreateEmptyTableRequest createRequest = new CreateEmptyTableRequest();
        for (String part : tableId.namespace()) {
            createRequest.addIdItem(part);
        }
        createRequest.addIdItem(tableId.name());
        if (properties != null && properties.containsKey(CREATE_TABLE_PROPERTY_LOCATION)) {
            createRequest.setLocation(properties.get(CREATE_TABLE_PROPERTY_LOCATION));
        }
        if (properties != null && !properties.isEmpty()) {
            createRequest.setProperties(properties);
        }
        CreateEmptyTableResponse response = this.namespace.createEmptyTable(createRequest);
        WriteParams.Builder writeParams = new WriteParams.Builder();
        writeParams.withStorageOptions(response.getStorageOptions());
        StructType processedSchema = SchemaConverter.processSchemaWithProperties(schema, properties);
        LanceDatasetAdapter.createDataset(response.getLocation(), processedSchema, writeParams.build());
        HashMap<String, String> storageOptions = response.getStorageOptions();
        if (storageOptions == null) {
            storageOptions = new HashMap<String, String>();
        }
        LanceConfig config = LanceConfig.from(storageOptions, response.getLocation());
        return this.createDataset(config, processedSchema);
    }

    public Table alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        throw new UnsupportedOperationException("Table alteration is not supported");
    }

    public boolean dropTable(Identifier ident) {
        try {
            Identifier tableId = this.transformIdentifierForApi(ident);
            DropTableRequest dropRequest = new DropTableRequest();
            for (String part : tableId.namespace()) {
                dropRequest.addIdItem(part);
            }
            dropRequest.addIdItem(tableId.name());
            this.namespace.dropTable(dropRequest);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) throws NoSuchTableException, TableAlreadyExistsException {
        throw new UnsupportedOperationException("Table renaming is not supported");
    }

    private Identifier removeExtraLevelsFromId(Identifier identifier) {
        if (this.extraLevel.isEmpty()) {
            return identifier;
        }
        String[] newNamespace = this.removeExtraLevelsFromNamespace(identifier.namespace());
        return Identifier.of((String[])newNamespace, (String)identifier.name());
    }

    private Identifier transformIdentifierForApi(Identifier identifier) {
        Identifier transformed = this.removeExtraLevelsFromId(identifier);
        String[] namespace = this.addParentPrefix(transformed.namespace());
        return Identifier.of((String[])namespace, (String)transformed.name());
    }

    private String[] removeExtraLevelsFromNamespace(String[] namespace) {
        if (this.extraLevel.isEmpty()) {
            return namespace;
        }
        String extraLevelName = this.extraLevel.get();
        if (namespace.length > 0 && extraLevelName.equals(namespace[0])) {
            String[] newNamespace = new String[namespace.length - 1];
            System.arraycopy(namespace, 1, newNamespace, 0, namespace.length - 1);
            return newNamespace;
        }
        return namespace;
    }

    /*
     * Exception decompiling
     */
    private byte[] createEmptyArrowIpcStream(JsonArrowSchema jsonSchema) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Optional<String> determineExtraLevelForRest() {
        try {
            ListNamespacesRequest request = new ListNamespacesRequest();
            this.namespace.listNamespaces(request);
            return Optional.empty();
        }
        catch (Exception e) {
            logger.info("REST namespace ListNamespaces failed, falling back to flat table structure with extra_level=default");
            return Optional.of("default");
        }
    }

    private String[] addParentPrefix(String[] namespace) {
        if (this.parentPrefix.isEmpty()) {
            return namespace;
        }
        ArrayList<String> result = new ArrayList<String>((Collection)this.parentPrefix.get());
        result.addAll(Arrays.asList(namespace));
        return result.toArray(new String[0]);
    }

    private String[] removeParentPrefix(String[] namespace) {
        if (this.parentPrefix.isEmpty()) {
            return namespace;
        }
        List<String> prefix = this.parentPrefix.get();
        if (namespace.length >= prefix.size()) {
            boolean hasPrefix = true;
            for (int i = 0; i < prefix.size(); ++i) {
                if (prefix.get(i).equals(namespace[i])) continue;
                hasPrefix = false;
                break;
            }
            if (hasPrefix) {
                String[] result = new String[namespace.length - prefix.size()];
                System.arraycopy(namespace, prefix.size(), result, 0, result.length);
                return result;
            }
        }
        return namespace;
    }

    public abstract LanceDataset createDataset(LanceConfig var1, StructType var2);
}

