/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.utils;

import java.util.Map;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.spark.sql.types.StructField;

public class BlobUtils {
    public static final String LANCE_ENCODING_BLOB_KEY = "lance-encoding:blob";
    public static final String LANCE_ENCODING_BLOB_VALUE = "true";

    public static boolean isBlobSparkField(StructField field) {
        if (field == null) {
            return false;
        }
        if (field.metadata() == null) {
            return false;
        }
        if (!field.metadata().contains(LANCE_ENCODING_BLOB_KEY)) {
            return false;
        }
        String value = field.metadata().getString(LANCE_ENCODING_BLOB_KEY);
        return LANCE_ENCODING_BLOB_VALUE.equalsIgnoreCase(value);
    }

    public static boolean isBlobArrowField(Field field) {
        if (field == null) {
            return false;
        }
        Map metadata = field.getMetadata();
        if (metadata == null) {
            return false;
        }
        if (!metadata.containsKey(LANCE_ENCODING_BLOB_KEY)) {
            return false;
        }
        String value = (String)metadata.get(LANCE_ENCODING_BLOB_KEY);
        return LANCE_ENCODING_BLOB_VALUE.equalsIgnoreCase(value);
    }
}

