/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.utils;

import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;

public class VectorUtils {
    public static final String ARROW_FIXED_SIZE_LIST_SIZE_KEY = "arrow.fixed-size-list.size";

    public static boolean isVectorField(StructField field) {
        if (field == null) {
            return false;
        }
        if (!(field.dataType() instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)field.dataType();
        DataType elementType = arrayType.elementType();
        if (!(elementType instanceof FloatType) && !(elementType instanceof DoubleType)) {
            return false;
        }
        if (field.metadata() == null) {
            return false;
        }
        return field.metadata().contains(ARROW_FIXED_SIZE_LIST_SIZE_KEY);
    }

    public static long getVectorDimension(StructField field) {
        if (!VectorUtils.isVectorField(field)) {
            return -1L;
        }
        try {
            return field.metadata().getLong(ARROW_FIXED_SIZE_LIST_SIZE_KEY);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static boolean isVectorArrowField(Field field) {
        if (field == null) {
            return false;
        }
        if (!(field.getType() instanceof ArrowType.FixedSizeList)) {
            return false;
        }
        if (field.getChildren().isEmpty()) {
            return false;
        }
        Field childField = (Field)field.getChildren().get(0);
        ArrowType childType = childField.getType();
        return childType instanceof ArrowType.FloatingPoint;
    }

    public static int getVectorArrowDimension(Field field) {
        if (!VectorUtils.isVectorArrowField(field)) {
            return -1;
        }
        ArrowType.FixedSizeList fixedSizeList = (ArrowType.FixedSizeList)field.getType();
        return fixedSizeList.getListSize();
    }

    public static boolean shouldBeFixedSizeList(DataType dataType, Metadata metadata) {
        if (metadata == null || !metadata.contains(ARROW_FIXED_SIZE_LIST_SIZE_KEY)) {
            return false;
        }
        if (!(dataType instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType elementType = arrayType.elementType();
        return elementType instanceof FloatType || elementType instanceof DoubleType;
    }

    public static String createVectorSizePropertyKey(String columnName) {
        return columnName + ".arrow.fixed-size-list.size";
    }
}

