/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.vectorized.BlobStructAccessor;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public class BlobSizeColumnVector
extends ColumnVector {
    private final BlobStructAccessor blobAccessor;

    public BlobSizeColumnVector(BlobStructAccessor blobAccessor) {
        super(DataTypes.LongType);
        this.blobAccessor = blobAccessor;
    }

    public void close() {
    }

    public boolean hasNull() {
        return this.blobAccessor.getNullCount() > 0;
    }

    public int numNulls() {
        return this.blobAccessor.getNullCount();
    }

    public boolean isNullAt(int rowId) {
        return this.blobAccessor.isNullAt(rowId);
    }

    public boolean getBoolean(int rowId) {
        throw new UnsupportedOperationException("Cannot get boolean from blob size");
    }

    public byte getByte(int rowId) {
        throw new UnsupportedOperationException("Cannot get byte from blob size");
    }

    public short getShort(int rowId) {
        throw new UnsupportedOperationException("Cannot get short from blob size");
    }

    public int getInt(int rowId) {
        Long size = this.blobAccessor.getSize(rowId);
        return size != null ? size.intValue() : 0;
    }

    public long getLong(int rowId) {
        Long size = this.blobAccessor.getSize(rowId);
        return size != null ? size : 0L;
    }

    public float getFloat(int rowId) {
        throw new UnsupportedOperationException("Cannot get float from blob size");
    }

    public double getDouble(int rowId) {
        throw new UnsupportedOperationException("Cannot get double from blob size");
    }

    public ColumnarArray getArray(int rowId) {
        throw new UnsupportedOperationException("Cannot get array from blob size");
    }

    public ColumnarMap getMap(int ordinal) {
        throw new UnsupportedOperationException("Cannot get map from blob size");
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        throw new UnsupportedOperationException("Cannot get decimal from blob size");
    }

    public UTF8String getUTF8String(int rowId) {
        throw new UnsupportedOperationException("Cannot get string from blob size");
    }

    public byte[] getBinary(int rowId) {
        throw new UnsupportedOperationException("Cannot get binary from blob size");
    }

    public ColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException("Blob size has no children");
    }
}

