/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import com.google.common.collect.ImmutableSet;
import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.read.LanceScanBuilder;
import com.lancedb.lance.spark.write.SparkWrite;
import java.util.Set;
import org.apache.spark.sql.connector.catalog.MetadataColumn;
import org.apache.spark.sql.connector.catalog.SupportsMetadataColumns;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class LanceDataset
implements SupportsRead,
SupportsWrite,
SupportsMetadataColumns {
    private static final Set<TableCapability> CAPABILITIES = ImmutableSet.of((Object)TableCapability.BATCH_READ, (Object)TableCapability.BATCH_WRITE, (Object)TableCapability.TRUNCATE);
    public static final MetadataColumn[] METADATA_COLUMNS = new MetadataColumn[]{new MetadataColumn(){

        public String name() {
            return "_rowid";
        }

        public DataType dataType() {
            return DataTypes.LongType;
        }
    }, new MetadataColumn(){

        public String name() {
            return "_rowaddr";
        }

        public DataType dataType() {
            return DataTypes.LongType;
        }
    }};
    LanceConfig config;
    private final StructType sparkSchema;

    public LanceDataset(LanceConfig config, StructType sparkSchema) {
        this.config = config;
        this.sparkSchema = sparkSchema;
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap caseInsensitiveStringMap) {
        return new LanceScanBuilder(this.sparkSchema, this.config);
    }

    public String name() {
        return this.config.getDatasetName();
    }

    public StructType schema() {
        return this.sparkSchema;
    }

    public Set<TableCapability> capabilities() {
        return CAPABILITIES;
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo logicalWriteInfo) {
        return new SparkWrite.SparkWriteBuilder(this.sparkSchema, this.config);
    }

    public MetadataColumn[] metadataColumns() {
        return METADATA_COLUMNS;
    }
}

