/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.read;

import com.lancedb.lance.spark.read.LanceColumnarPartitionReader;
import com.lancedb.lance.spark.read.LanceInputPartition;
import java.io.IOException;
import java.util.Iterator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class LanceRowPartitionReader
implements PartitionReader<InternalRow> {
    private final LanceColumnarPartitionReader reader;
    private ColumnarBatch currentBatch;
    private Iterator<InternalRow> currentRows;
    private InternalRow currentRecord;

    public LanceRowPartitionReader(LanceColumnarPartitionReader reader) {
        this.reader = reader;
    }

    public static LanceRowPartitionReader create(LanceInputPartition inputPartition) {
        return new LanceRowPartitionReader(new LanceColumnarPartitionReader(inputPartition));
    }

    public boolean next() throws IOException {
        if (this.currentRows != null && this.currentRows.hasNext()) {
            this.currentRecord = this.currentRows.next();
            return true;
        }
        if (this.reader.next()) {
            this.currentBatch = this.reader.get();
            this.currentRows = this.currentBatch.rowIterator();
            if (this.currentRows != null && this.currentRows.hasNext()) {
                this.currentRecord = this.currentRows.next();
                return true;
            }
        }
        return false;
    }

    public InternalRow get() {
        return this.currentRecord;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

