/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.write;

import com.google.common.base.Preconditions;
import com.lancedb.lance.spark.arrow.LanceArrowWriter$;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class LanceArrowWriter
extends ArrowReader {
    private final Schema schema;
    private final StructType sparkSchema;
    private final int batchSize;
    @GuardedBy(value="monitor")
    private volatile boolean finished = false;
    private final AtomicLong totalBytesRead = new AtomicLong();
    private com.lancedb.lance.spark.arrow.LanceArrowWriter arrowWriter = null;
    private final AtomicInteger count = new AtomicInteger(0);
    private final Semaphore writeToken;
    private final Semaphore loadToken;

    public LanceArrowWriter(BufferAllocator allocator, Schema schema, StructType sparkSchema, int batchSize) {
        super(allocator);
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0);
        this.schema = schema;
        this.sparkSchema = sparkSchema;
        this.batchSize = batchSize;
        this.writeToken = new Semaphore(0);
        this.loadToken = new Semaphore(0);
    }

    void write(InternalRow row) {
        Preconditions.checkNotNull((Object)row);
        try {
            this.writeToken.acquire();
            this.arrowWriter.write(row);
            if (this.count.incrementAndGet() == this.batchSize) {
                this.loadToken.release();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    void setFinished() {
        this.finished = true;
        this.loadToken.release();
    }

    public void prepareLoadNextBatch() throws IOException {
        super.prepareLoadNextBatch();
        this.arrowWriter = LanceArrowWriter$.MODULE$.create(this.getVectorSchemaRoot(), this.sparkSchema);
        this.writeToken.release(this.batchSize);
    }

    public boolean loadNextBatch() throws IOException {
        this.prepareLoadNextBatch();
        try {
            if (this.finished && this.count.get() == 0) {
                return false;
            }
            this.loadToken.acquire();
            this.arrowWriter.finish();
            if (!this.finished) {
                this.count.set(0);
                return true;
            }
            if (this.count.get() > 0) {
                this.count.set(0);
                return true;
            }
            return false;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public long bytesRead() {
        throw new UnsupportedOperationException();
    }

    protected synchronized void closeReadSource() throws IOException {
    }

    protected Schema readSchema() {
        return this.schema;
    }
}

