/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.read;

import com.google.common.collect.Lists;
import com.lancedb.lance.Dataset;
import com.lancedb.lance.ReadOptions;
import com.lancedb.lance.ipc.LanceScanner;
import com.lancedb.lance.ipc.ScanOptions;
import com.lancedb.lance.spark.SparkOptions;
import com.lancedb.lance.spark.internal.LanceDatasetAdapter;
import com.lancedb.lance.spark.read.LanceInputPartition;
import java.io.IOException;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.LanceArrowUtils;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.sql.vectorized.LanceArrowColumnVector;

public class LanceCountStarPartitionReader
implements PartitionReader<ColumnarBatch> {
    private final LanceInputPartition inputPartition;
    private final BufferAllocator allocator;
    private boolean finished = false;
    private ColumnarBatch currentBatch;

    public LanceCountStarPartitionReader(LanceInputPartition inputPartition) {
        this.inputPartition = inputPartition;
        this.allocator = LanceDatasetAdapter.allocator;
    }

    public boolean next() throws IOException {
        if (!this.finished) {
            this.finished = true;
            return true;
        }
        return false;
    }

    private long computeCount() {
        String uri = this.inputPartition.getConfig().getDatasetUri();
        ReadOptions options = SparkOptions.genReadOptionFromConfig(this.inputPartition.getConfig());
        long totalCount = 0L;
        try (Dataset dataset = Dataset.open((BufferAllocator)this.allocator, (String)uri, (ReadOptions)options);){
            List<Integer> fragmentIds = this.inputPartition.getLanceSplit().getFragments();
            if (fragmentIds.isEmpty()) {
                long l = 0L;
                return l;
            }
            ScanOptions.Builder scanOptionsBuilder = new ScanOptions.Builder();
            if (this.inputPartition.getWhereCondition().isPresent()) {
                scanOptionsBuilder.filter(this.inputPartition.getWhereCondition().get());
            }
            scanOptionsBuilder.withRowId(true);
            scanOptionsBuilder.columns((List)Lists.newArrayList());
            scanOptionsBuilder.fragmentIds(fragmentIds);
            try (LanceScanner scanner = dataset.newScan(scanOptionsBuilder.build());
                 ArrowReader reader = scanner.scanBatches();){
                while (reader.loadNextBatch()) {
                    totalCount += (long)reader.getVectorSchemaRoot().getRowCount();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to scan fragment " + String.valueOf(fragmentIds), e);
            }
        }
        return totalCount;
    }

    private ColumnarBatch createCountResultBatch(long count, StructType resultSchema) {
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)LanceArrowUtils.toArrowSchema(resultSchema, "UTC", false, false), (BufferAllocator)this.allocator);
        root.allocateNew();
        BigIntVector countVector = (BigIntVector)root.getVector("count");
        countVector.setSafe(0, count);
        root.setRowCount(1);
        ColumnVector[] columns = (LanceArrowColumnVector[])root.getFieldVectors().stream().map(LanceArrowColumnVector::new).toArray(LanceArrowColumnVector[]::new);
        return new ColumnarBatch(columns, 1);
    }

    public ColumnarBatch get() {
        long rowCount = this.computeCount();
        StructType countSchema = new StructType().add("count", DataTypes.LongType);
        return this.createCountResultBatch(rowCount, countSchema);
    }

    public void close() throws IOException {
        if (this.currentBatch != null) {
            this.currentBatch.close();
        }
    }
}

