/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.write;

import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.write.AddColumnsBackfillBatchWrite;
import java.util.List;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.NullOrdering;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.expressions.SortValue;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.RequiresDistributionAndOrdering;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.apache.spark.sql.types.StructType;

public class AddColumnsBackfillWrite
implements Write,
RequiresDistributionAndOrdering {
    private final LanceConfig config;
    private final StructType schema;
    private final List<String> newColumns;

    AddColumnsBackfillWrite(StructType schema, LanceConfig config, List<String> newColumns) {
        this.schema = schema;
        this.config = config;
        this.newColumns = newColumns;
    }

    public BatchWrite toBatch() {
        return new AddColumnsBackfillBatchWrite(this.schema, this.config, this.newColumns);
    }

    public StreamingWrite toStreaming() {
        throw new UnsupportedOperationException();
    }

    public Distribution requiredDistribution() {
        NamedReference segmentId = Expressions.column((String)"_fragid");
        return Distributions.clustered((Expression[])new NamedReference[]{segmentId});
    }

    public SortOrder[] requiredOrdering() {
        NamedReference segmentId = Expressions.column((String)"_rowaddr");
        SortValue sortValue = new SortValue((Expression)segmentId, SortDirection.ASCENDING, NullOrdering.NULLS_FIRST);
        return new SortValue[]{sortValue};
    }

    public static class AddColumnsWriteBuilder
    implements WriteBuilder {
        private final LanceConfig config;
        private final StructType schema;
        private final List<String> newColumns;

        public AddColumnsWriteBuilder(StructType schema, LanceConfig config, List<String> newColumns) {
            this.schema = schema;
            this.config = config;
            this.newColumns = newColumns;
        }

        public Write build() {
            return new AddColumnsBackfillWrite(this.schema, this.config, this.newColumns);
        }
    }
}

