/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.vectorized.BlobStructAccessor;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public class BlobPositionColumnVector
extends ColumnVector {
    private final BlobStructAccessor blobAccessor;

    public BlobPositionColumnVector(BlobStructAccessor blobAccessor) {
        super(DataTypes.LongType);
        this.blobAccessor = blobAccessor;
    }

    public void close() {
    }

    public boolean hasNull() {
        return this.blobAccessor.getNullCount() > 0;
    }

    public int numNulls() {
        return this.blobAccessor.getNullCount();
    }

    public boolean isNullAt(int rowId) {
        return this.blobAccessor.isNullAt(rowId);
    }

    public boolean getBoolean(int rowId) {
        throw new UnsupportedOperationException("Cannot get boolean from blob position");
    }

    public byte getByte(int rowId) {
        throw new UnsupportedOperationException("Cannot get byte from blob position");
    }

    public short getShort(int rowId) {
        throw new UnsupportedOperationException("Cannot get short from blob position");
    }

    public int getInt(int rowId) {
        Long position = this.blobAccessor.getPosition(rowId);
        return position != null ? position.intValue() : 0;
    }

    public long getLong(int rowId) {
        Long position = this.blobAccessor.getPosition(rowId);
        return position != null ? position : 0L;
    }

    public float getFloat(int rowId) {
        throw new UnsupportedOperationException("Cannot get float from blob position");
    }

    public double getDouble(int rowId) {
        throw new UnsupportedOperationException("Cannot get double from blob position");
    }

    public ColumnarArray getArray(int rowId) {
        throw new UnsupportedOperationException("Cannot get array from blob position");
    }

    public ColumnarMap getMap(int ordinal) {
        throw new UnsupportedOperationException("Cannot get map from blob position");
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        throw new UnsupportedOperationException("Cannot get decimal from blob position");
    }

    public UTF8String getUTF8String(int rowId) {
        throw new UnsupportedOperationException("Cannot get string from blob position");
    }

    public byte[] getBinary(int rowId) {
        throw new UnsupportedOperationException("Cannot get binary from blob position");
    }

    public ColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException("Blob position has no children");
    }
}

