/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;

public class BlobStructAccessor
implements AutoCloseable {
    private final StructVector structVector;
    private final UInt8Vector positionVector;
    private final UInt8Vector sizeVector;

    public BlobStructAccessor(StructVector structVector) {
        this.structVector = structVector;
        this.positionVector = (UInt8Vector)structVector.getChild("position");
        this.sizeVector = (UInt8Vector)structVector.getChild("size");
    }

    public int getNullCount() {
        return this.structVector.getNullCount();
    }

    public boolean isNullAt(int rowId) {
        return this.structVector.isNull(rowId);
    }

    public InternalRow getStruct(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        Object[] values = new Object[]{this.positionVector.isNull(rowId) ? null : this.positionVector.getObjectNoOverflow(rowId), this.sizeVector.isNull(rowId) ? null : this.sizeVector.getObjectNoOverflow(rowId)};
        return new GenericInternalRow(values);
    }

    public Long getPosition(int rowId) {
        if (this.isNullAt(rowId) || this.positionVector.isNull(rowId)) {
            return null;
        }
        return this.positionVector.getObjectNoOverflow(rowId).longValue();
    }

    public Long getSize(int rowId) {
        if (this.isNullAt(rowId) || this.sizeVector.isNull(rowId)) {
            return null;
        }
        return this.sizeVector.getObjectNoOverflow(rowId).longValue();
    }

    @Override
    public void close() {
    }
}

