/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.LanceDataset;
import com.lancedb.lance.spark.LanceIdentifier;
import com.lancedb.lance.spark.internal.LanceDatasetAdapter;
import com.lancedb.lance.spark.utils.Optional;
import java.util.Map;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public abstract class LanceDataSource
implements SupportsCatalogOptions,
DataSourceRegister {
    public static final String name = "lance";

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        Optional<StructType> schema = LanceDatasetAdapter.getSchema(LanceConfig.from(options));
        return schema.isPresent() ? schema.get() : null;
    }

    public Table getTable(StructType schema, Transform[] partitioning, Map<String, String> properties) {
        return this.createDataset(LanceConfig.from(properties), schema);
    }

    public String shortName() {
        return name;
    }

    public Identifier extractIdentifier(CaseInsensitiveStringMap options) {
        return new LanceIdentifier(LanceConfig.from(options).getDatasetUri());
    }

    public String extractCatalog(CaseInsensitiveStringMap options) {
        return name;
    }

    public abstract LanceDataset createDataset(LanceConfig var1, StructType var2);
}

