/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import com.google.common.collect.ImmutableSet;
import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.read.LanceScanBuilder;
import com.lancedb.lance.spark.utils.BlobUtils;
import com.lancedb.lance.spark.write.AddColumnsBackfillWrite;
import com.lancedb.lance.spark.write.SparkWrite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.sql.connector.catalog.MetadataColumn;
import org.apache.spark.sql.connector.catalog.SupportsMetadataColumns;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class LanceDataset
implements SupportsRead,
SupportsWrite,
SupportsMetadataColumns {
    private static final Set<TableCapability> CAPABILITIES = ImmutableSet.of((Object)TableCapability.BATCH_READ, (Object)TableCapability.BATCH_WRITE, (Object)TableCapability.TRUNCATE);
    public static final MetadataColumn FRAGMENT_ID_COLUMN = new MetadataColumn(){

        public String name() {
            return "_fragid";
        }

        public DataType dataType() {
            return DataTypes.IntegerType;
        }

        public boolean isNullable() {
            return false;
        }
    };
    public static final MetadataColumn ROW_ID_COLUMN = new MetadataColumn(){

        public String name() {
            return "_rowid";
        }

        public DataType dataType() {
            return DataTypes.LongType;
        }
    };
    public static final MetadataColumn ROW_ADDRESS_COLUMN = new MetadataColumn(){

        public String name() {
            return "_rowaddr";
        }

        public DataType dataType() {
            return DataTypes.LongType;
        }

        public boolean isNullable() {
            return false;
        }
    };
    public static final MetadataColumn[] METADATA_COLUMNS = new MetadataColumn[]{ROW_ID_COLUMN, ROW_ADDRESS_COLUMN, FRAGMENT_ID_COLUMN};
    LanceConfig config;
    protected final StructType sparkSchema;

    public LanceDataset(LanceConfig config, StructType sparkSchema) {
        this.config = config;
        this.sparkSchema = sparkSchema;
    }

    public LanceConfig config() {
        return this.config;
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap caseInsensitiveStringMap) {
        return new LanceScanBuilder(this.sparkSchema, this.config);
    }

    public String name() {
        return this.config.getDatasetName();
    }

    public StructType schema() {
        return this.sparkSchema;
    }

    public Set<TableCapability> capabilities() {
        return CAPABILITIES;
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo logicalWriteInfo) {
        List<String> backfillColumns = Arrays.stream(((String)logicalWriteInfo.options().getOrDefault((Object)"backfill_columns", (Object)"")).split(",")).map(String::trim).filter(t -> !t.isEmpty()).collect(Collectors.toList());
        if (!backfillColumns.isEmpty()) {
            return new AddColumnsBackfillWrite.AddColumnsWriteBuilder(this.sparkSchema, this.config, backfillColumns);
        }
        return new SparkWrite.SparkWriteBuilder(this.sparkSchema, this.config);
    }

    public MetadataColumn[] metadataColumns() {
        ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
        for (MetadataColumn metadataColumn : METADATA_COLUMNS) {
            columns.add(metadataColumn);
        }
        for (MetadataColumn metadataColumn : this.sparkSchema.fields()) {
            if (!BlobUtils.isBlobSparkField((StructField)metadataColumn)) continue;
            final String fieldName = metadataColumn.name();
            columns.add(new MetadataColumn(){

                public String name() {
                    return fieldName + "__blob_pos";
                }

                public DataType dataType() {
                    return DataTypes.LongType;
                }

                public boolean isNullable() {
                    return true;
                }
            });
            columns.add(new MetadataColumn(){

                public String name() {
                    return fieldName + "__blob_size";
                }

                public DataType dataType() {
                    return DataTypes.LongType;
                }

                public boolean isNullable() {
                    return true;
                }
            });
        }
        return columns.toArray(new MetadataColumn[0]);
    }
}

