/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.read.LanceScanBuilder;
import com.lancedb.lance.spark.write.SparkPositionDeltaWriteBuilder;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.DeltaWriteBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.apache.spark.sql.connector.write.SupportsDelta;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class LancePositionDeltaOperation
implements RowLevelOperation,
SupportsDelta {
    private final RowLevelOperation.Command command;
    private final StructType sparkSchema;
    private final LanceConfig config;

    public LancePositionDeltaOperation(RowLevelOperation.Command command, StructType sparkSchema, LanceConfig config) {
        this.command = command;
        this.sparkSchema = sparkSchema;
        this.config = config;
    }

    public RowLevelOperation.Command command() {
        return this.command;
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap caseInsensitiveStringMap) {
        return new LanceScanBuilder(this.sparkSchema, this.config);
    }

    public DeltaWriteBuilder newWriteBuilder(LogicalWriteInfo logicalWriteInfo) {
        return new SparkPositionDeltaWriteBuilder(this.sparkSchema, this.config);
    }

    public NamedReference[] rowId() {
        NamedReference rowAddr = Expressions.column((String)"_rowaddr");
        return new NamedReference[]{rowAddr};
    }

    public NamedReference[] requiredMetadataAttributes() {
        NamedReference segmentId = Expressions.column((String)"_fragid");
        return new NamedReference[]{segmentId};
    }

    public boolean representUpdateAsDeleteAndInsert() {
        return true;
    }
}

