/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.internal;

import com.lancedb.lance.Dataset;
import com.lancedb.lance.Fragment;
import com.lancedb.lance.FragmentMetadata;
import com.lancedb.lance.FragmentOperation;
import com.lancedb.lance.ReadOptions;
import com.lancedb.lance.WriteParams;
import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.SparkOptions;
import com.lancedb.lance.spark.internal.LanceFragmentScanner;
import com.lancedb.lance.spark.read.LanceInputPartition;
import com.lancedb.lance.spark.write.LanceArrowWriter;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.arrow.c.ArrowArrayStream;
import org.apache.arrow.c.Data;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.LanceArrowUtils;

public class LanceDatasetAdapter {
    public static final BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);

    public static com.lancedb.lance.spark.utils.Optional<StructType> getSchema(LanceConfig config) {
        com.lancedb.lance.spark.utils.Optional<StructType> optional;
        block8: {
            String uri = config.getDatasetUri();
            ReadOptions options = SparkOptions.genReadOptionFromConfig(config);
            Dataset dataset = Dataset.open((BufferAllocator)allocator, (String)uri, (ReadOptions)options);
            try {
                optional = com.lancedb.lance.spark.utils.Optional.of(LanceArrowUtils.fromArrowSchema(dataset.getSchema()));
                if (dataset == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dataset != null) {
                        try {
                            dataset.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    return com.lancedb.lance.spark.utils.Optional.empty();
                }
            }
            dataset.close();
        }
        return optional;
    }

    public static com.lancedb.lance.spark.utils.Optional<StructType> getSchema(String datasetUri) {
        com.lancedb.lance.spark.utils.Optional<StructType> optional;
        block8: {
            Dataset dataset = Dataset.open((String)datasetUri, (BufferAllocator)allocator);
            try {
                optional = com.lancedb.lance.spark.utils.Optional.of(LanceArrowUtils.fromArrowSchema(dataset.getSchema()));
                if (dataset == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dataset != null) {
                        try {
                            dataset.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    return com.lancedb.lance.spark.utils.Optional.empty();
                }
            }
            dataset.close();
        }
        return optional;
    }

    public static com.lancedb.lance.spark.utils.Optional<Long> getDatasetRowCount(LanceConfig config) {
        com.lancedb.lance.spark.utils.Optional<Long> optional;
        block8: {
            String uri = config.getDatasetUri();
            ReadOptions options = SparkOptions.genReadOptionFromConfig(config);
            Dataset dataset = Dataset.open((BufferAllocator)allocator, (String)uri, (ReadOptions)options);
            try {
                optional = com.lancedb.lance.spark.utils.Optional.of(dataset.countRows());
                if (dataset == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dataset != null) {
                        try {
                            dataset.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    return com.lancedb.lance.spark.utils.Optional.empty();
                }
            }
            dataset.close();
        }
        return optional;
    }

    public static com.lancedb.lance.spark.utils.Optional<Long> getDatasetDataSize(LanceConfig config) {
        com.lancedb.lance.spark.utils.Optional<Long> optional;
        block8: {
            String uri = config.getDatasetUri();
            ReadOptions options = SparkOptions.genReadOptionFromConfig(config);
            Dataset dataset = Dataset.open((BufferAllocator)allocator, (String)uri, (ReadOptions)options);
            try {
                optional = com.lancedb.lance.spark.utils.Optional.of(dataset.calculateDataSize());
                if (dataset == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dataset != null) {
                        try {
                            dataset.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    return com.lancedb.lance.spark.utils.Optional.empty();
                }
            }
            dataset.close();
        }
        return optional;
    }

    public static List<Integer> getFragmentIds(LanceConfig config) {
        String uri = config.getDatasetUri();
        ReadOptions options = SparkOptions.genReadOptionFromConfig(config);
        try (Dataset dataset = Dataset.open((BufferAllocator)allocator, (String)uri, (ReadOptions)options);){
            List<Integer> list = dataset.getFragments().stream().map(Fragment::getId).collect(Collectors.toList());
            return list;
        }
    }

    public static LanceFragmentScanner getFragmentScanner(int fragmentId, LanceInputPartition inputPartition) {
        return LanceFragmentScanner.create(fragmentId, inputPartition);
    }

    public static void appendFragments(LanceConfig config, List<FragmentMetadata> fragments) {
        FragmentOperation.Append appendOp = new FragmentOperation.Append(fragments);
        String uri = config.getDatasetUri();
        ReadOptions options = SparkOptions.genReadOptionFromConfig(config);
        try (Dataset datasetRead = Dataset.open((BufferAllocator)allocator, (String)uri, (ReadOptions)options);){
            Dataset.commit((BufferAllocator)allocator, (String)config.getDatasetUri(), (FragmentOperation)appendOp, Optional.of(datasetRead.version()), (Map)options.getStorageOptions()).close();
        }
    }

    public static void overwriteFragments(LanceConfig config, List<FragmentMetadata> fragments, StructType sparkSchema) {
        Schema schema = LanceArrowUtils.toArrowSchema(sparkSchema, "UTC", false, false);
        FragmentOperation.Overwrite overwrite = new FragmentOperation.Overwrite(fragments, schema);
        String uri = config.getDatasetUri();
        ReadOptions options = SparkOptions.genReadOptionFromConfig(config);
        try (Dataset datasetRead = Dataset.open((BufferAllocator)allocator, (String)uri, (ReadOptions)options);){
            Dataset.commit((BufferAllocator)allocator, (String)config.getDatasetUri(), (FragmentOperation)overwrite, Optional.of(datasetRead.version()), (Map)options.getStorageOptions()).close();
        }
    }

    public static LanceArrowWriter getArrowWriter(StructType sparkSchema, int batchSize) {
        return new LanceArrowWriter(allocator, LanceArrowUtils.toArrowSchema(sparkSchema, "UTC", false, false), sparkSchema, batchSize);
    }

    public static List<FragmentMetadata> createFragment(String datasetUri, ArrowReader reader, WriteParams params) {
        try (ArrowArrayStream arrowStream = ArrowArrayStream.allocateNew((BufferAllocator)allocator);){
            Data.exportArrayStream((BufferAllocator)allocator, (ArrowReader)reader, (ArrowArrayStream)arrowStream);
            List list = Fragment.create((String)datasetUri, (ArrowArrayStream)arrowStream, (WriteParams)params);
            return list;
        }
    }

    public static void createDataset(String datasetUri, StructType sparkSchema, WriteParams params) {
        Dataset.create((BufferAllocator)allocator, (String)datasetUri, (Schema)LanceArrowUtils.toArrowSchema(sparkSchema, ZoneId.systemDefault().getId(), true, false), (WriteParams)params).close();
    }

    public static void dropDataset(LanceConfig config) {
        String uri = config.getDatasetUri();
        ReadOptions options = SparkOptions.genReadOptionFromConfig(config);
        Dataset.drop((String)uri, (Map)options.getStorageOptions());
    }
}

