/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.read;

import com.lancedb.lance.spark.internal.LanceFragmentColumnarBatchScanner;
import com.lancedb.lance.spark.read.LanceInputPartition;
import java.io.IOException;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class LanceColumnarPartitionReader
implements PartitionReader<ColumnarBatch> {
    private final LanceInputPartition inputPartition;
    private int fragmentIndex;
    private LanceFragmentColumnarBatchScanner fragmentReader;
    private ColumnarBatch currentBatch;

    public LanceColumnarPartitionReader(LanceInputPartition inputPartition) {
        this.inputPartition = inputPartition;
        this.fragmentIndex = 0;
    }

    public boolean next() throws IOException {
        if (this.loadNextBatchFromCurrentReader()) {
            return true;
        }
        while (this.fragmentIndex < this.inputPartition.getLanceSplit().getFragments().size()) {
            if (this.fragmentReader != null) {
                this.fragmentReader.close();
            }
            this.fragmentReader = LanceFragmentColumnarBatchScanner.create(this.inputPartition.getLanceSplit().getFragments().get(this.fragmentIndex), this.inputPartition);
            ++this.fragmentIndex;
            if (!this.loadNextBatchFromCurrentReader()) continue;
            return true;
        }
        return false;
    }

    private boolean loadNextBatchFromCurrentReader() throws IOException {
        if (this.fragmentReader != null && this.fragmentReader.loadNextBatch()) {
            this.currentBatch = this.fragmentReader.getCurrentBatch();
            return true;
        }
        return false;
    }

    public ColumnarBatch get() {
        return this.currentBatch;
    }

    public void close() throws IOException {
        if (this.fragmentReader != null) {
            try {
                this.fragmentReader.close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

